/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.nms.v1_13_R2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.hologram.Hologram;
import net.jitse.npclib.internal.MinecraftVersion;
import net.jitse.npclib.internal.SimpleNPC;
import net.jitse.npclib.nms.v1_13_R2.packets.PacketPlayOutEntityHeadRotationWrapper;
import net.jitse.npclib.nms.v1_13_R2.packets.PacketPlayOutNamedEntitySpawnWrapper;
import net.jitse.npclib.nms.v1_13_R2.packets.PacketPlayOutPlayerInfoWrapper;
import net.jitse.npclib.nms.v1_13_R2.packets.PacketPlayOutScoreboardTeamWrapper;
import net.minecraft.server.v1_13_R2.Packet;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_13_R2.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_13_R2.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_13_R2.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_13_R2.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_13_R2.PlayerConnection;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class NPC_v1_13_R2
extends SimpleNPC {
    private Hologram hologram;
    private PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn;
    private PacketPlayOutScoreboardTeam packetPlayOutScoreboardTeamRegister;
    private PacketPlayOutPlayerInfo packetPlayOutPlayerInfoAdd;
    private PacketPlayOutPlayerInfo packetPlayOutPlayerInfoRemove;
    private PacketPlayOutEntityHeadRotation packetPlayOutEntityHeadRotation;
    private PacketPlayOutEntityDestroy packetPlayOutEntityDestroy;
    private Set<UUID> hasTeamRegistered = new HashSet<UUID>();

    public NPC_v1_13_R2(NPCLib instance, List<String> lines) {
        super(instance, lines);
    }

    @Override
    public void createPackets() {
        this.hologram = new Hologram(this.location.clone().add(0.0, 0.5, 0.0), this.lines);
        this.hologram.generatePackets(MinecraftVersion.V1_13_R2);
        PacketPlayOutPlayerInfoWrapper packetPlayOutPlayerInfoWrapper = new PacketPlayOutPlayerInfoWrapper();
        this.packetPlayOutScoreboardTeamRegister = new PacketPlayOutScoreboardTeamWrapper().createRegisterTeam(this.name);
        this.packetPlayOutPlayerInfoAdd = packetPlayOutPlayerInfoWrapper.create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, this.gameProfile, this.name);
        this.packetPlayOutNamedEntitySpawn = new PacketPlayOutNamedEntitySpawnWrapper().create(this.uuid, this.location, this.entityId);
        this.packetPlayOutEntityHeadRotation = new PacketPlayOutEntityHeadRotationWrapper().create(this.location, this.entityId);
        this.packetPlayOutPlayerInfoRemove = packetPlayOutPlayerInfoWrapper.create(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, this.gameProfile, this.name);
        this.packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.entityId});
    }

    @Override
    public void onLogout(Player player) {
        super.onLogout(player);
        this.hasTeamRegistered.remove(player.getUniqueId());
    }

    @Override
    public void sendShowPackets(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        if (this.hasTeamRegistered.add(player.getUniqueId())) {
            playerConnection.sendPacket((Packet)this.packetPlayOutScoreboardTeamRegister);
        }
        playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoAdd);
        playerConnection.sendPacket((Packet)this.packetPlayOutNamedEntitySpawn);
        playerConnection.sendPacket((Packet)this.packetPlayOutEntityHeadRotation);
        this.hologram.spawn(player);
        Bukkit.getScheduler().runTaskLater((Plugin)this.instance.getPlugin(), () -> playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove), 50L);
    }

    @Override
    public void sendHidePackets(Player player) {
        PlayerConnection playerConnection = ((CraftPlayer)player).getHandle().playerConnection;
        playerConnection.sendPacket((Packet)this.packetPlayOutEntityDestroy);
        playerConnection.sendPacket((Packet)this.packetPlayOutPlayerInfoRemove);
        this.hologram.destroy(player);
    }
}

