/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.listeners;

import net.jitse.npclib.NPCLib;
import net.jitse.npclib.internal.NPCManager;
import net.jitse.npclib.internal.SimpleNPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class PlayerListener
implements Listener {
    private final NPCLib instance;

    public PlayerListener(NPCLib instance) {
        this.instance = instance;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.onPlayerLeave(event.getPlayer());
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onPlayerKick(PlayerKickEvent event) {
        this.onPlayerLeave(event.getPlayer());
    }

    private void onPlayerLeave(Player player) {
        for (SimpleNPC npc : NPCManager.getAllNPCs()) {
            npc.onLogout(player);
        }
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        World from = event.getFrom();
        for (SimpleNPC npc : NPCManager.getAllNPCs()) {
            if (!npc.getWorld().equals(from) || npc.getAutoHidden().contains(player.getUniqueId())) continue;
            npc.getAutoHidden().add(player.getUniqueId());
            npc.hide(player, true);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null || from.getBlockX() != to.getBlockX() || from.getBlockY() != to.getBlockY() || from.getBlockZ() != to.getBlockZ()) {
            this.handleMove(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        this.handleMove(event.getPlayer());
    }

    private void handleMove(Player player) {
        World world = player.getWorld();
        for (SimpleNPC npc : NPCManager.getAllNPCs()) {
            boolean inRange;
            if (!npc.getShown().contains(player.getUniqueId()) || !npc.getWorld().equals(world)) continue;
            double hideDistance = this.instance.getAutoHideDistance();
            double distanceSquared = player.getLocation().distanceSquared(npc.getLocation());
            int tempRange = Bukkit.getViewDistance() << 4;
            boolean bl = inRange = distanceSquared <= hideDistance * hideDistance && distanceSquared <= (double)(tempRange * tempRange);
            if (npc.getAutoHidden().contains(player.getUniqueId())) {
                if (!inRange) continue;
                npc.getAutoHidden().remove(player.getUniqueId());
                npc.show(player, true);
                continue;
            }
            if (inRange) continue;
            npc.getAutoHidden().add(player.getUniqueId());
            npc.hide(player, true);
        }
    }
}

