/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.listeners;

import com.comphenix.tinyprotocol.Reflection;
import com.comphenix.tinyprotocol.TinyProtocol;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.api.events.NPCInteractEvent;
import net.jitse.npclib.internal.NPCManager;
import net.jitse.npclib.internal.SimpleNPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PacketListener {
    private final Class<?> packetPlayInUseEntityClazz = Reflection.getMinecraftClass("PacketPlayInUseEntity");
    private final Reflection.FieldAccessor entityIdField = Reflection.getField(this.packetPlayInUseEntityClazz, "a", Integer.TYPE);
    private final Reflection.FieldAccessor actionField = Reflection.getField(this.packetPlayInUseEntityClazz, "action", Object.class);
    private final Set<UUID> delay = new HashSet<UUID>();
    private Plugin plugin;

    public void start(NPCLib instance) {
        this.plugin = instance.getPlugin();
        new TinyProtocol(instance){

            @Override
            public Object onPacketInAsync(Player player, Object packet) {
                return PacketListener.this.handleInteractPacket(player, packet) ? super.onPacketInAsync(player, packet) : null;
            }
        };
    }

    private boolean handleInteractPacket(Player player, Object packet) {
        if (!this.packetPlayInUseEntityClazz.isInstance(packet)) {
            return true;
        }
        SimpleNPC npc = null;
        int packetEntityId = (Integer)this.entityIdField.get(packet);
        for (SimpleNPC testNPC : NPCManager.getAllNPCs()) {
            if (!testNPC.isShown(player) || testNPC.getEntityId() != packetEntityId) continue;
            npc = testNPC;
            break;
        }
        if (npc == null) {
            return true;
        }
        if (this.delay.contains(player.getUniqueId())) {
            return false;
        }
        NPCInteractEvent.ClickType clickType = this.actionField.get(packet).toString().equals("ATTACK") ? NPCInteractEvent.ClickType.LEFT_CLICK : NPCInteractEvent.ClickType.RIGHT_CLICK;
        this.delay.add(player.getUniqueId());
        Bukkit.getScheduler().runTask(this.plugin, (Runnable)new TaskCallNpcInteractEvent(new NPCInteractEvent(player, clickType, npc), this));
        return false;
    }

    private static final class TaskCallNpcInteractEvent
    implements Runnable {
        private NPCInteractEvent eventToCall;
        private PacketListener listener;
        private static Location playerLocation = new Location(null, 0.0, 0.0, 0.0);

        TaskCallNpcInteractEvent(NPCInteractEvent eventToCall, PacketListener listener) {
            this.eventToCall = eventToCall;
            this.listener = listener;
        }

        @Override
        public void run() {
            Player player = this.eventToCall.getWhoClicked();
            this.listener.delay.remove(player.getUniqueId());
            if (!Objects.equals(player.getWorld(), this.eventToCall.getNPC().getWorld())) {
                return;
            }
            double distance = player.getLocation(playerLocation).distanceSquared(this.eventToCall.getNPC().getLocation());
            if (distance <= 64.0) {
                Bukkit.getPluginManager().callEvent((Event)this.eventToCall);
            }
        }
    }
}

