/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.internal;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.jitse.npclib.NPCLib;
import net.jitse.npclib.api.NPC;
import net.jitse.npclib.api.events.NPCHideEvent;
import net.jitse.npclib.api.events.NPCShowEvent;
import net.jitse.npclib.api.skin.Skin;
import net.jitse.npclib.internal.NPCManager;
import net.jitse.npclib.internal.PacketHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.util.Vector;

public abstract class SimpleNPC
implements NPC,
PacketHandler {
    protected final UUID uuid = UUID.randomUUID();
    protected final int entityId = Integer.MAX_VALUE - NPCManager.getAllNPCs().size();
    protected final String name = this.uuid.toString().replace("-", "").substring(0, 10);
    protected final GameProfile gameProfile = new GameProfile(this.uuid, this.name);
    protected final List<String> lines;
    private final Set<UUID> shown = new HashSet<UUID>();
    private final Set<UUID> autoHidden = new HashSet<UUID>();
    protected double cosFOV = Math.cos(Math.toRadians(60.0));
    protected NPCLib instance;
    protected Location location;
    protected Skin skin;

    public SimpleNPC(NPCLib instance, List<String> lines) {
        this.instance = instance;
        this.lines = lines == null ? Collections.emptyList() : lines;
        NPCManager.add(this);
    }

    public NPCLib getInstance() {
        return this.instance;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public NPC setSkin(Skin skin) {
        this.skin = skin;
        this.gameProfile.getProperties().get((Object)"textures").clear();
        if (skin != null) {
            this.gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", skin.getValue(), skin.getSignature()));
        }
        return this;
    }

    @Override
    public void destroy() {
        NPCManager.remove(this);
        for (UUID uuid : this.shown) {
            if (this.autoHidden.contains(uuid)) continue;
            this.hide(Bukkit.getPlayer((UUID)uuid), true);
        }
    }

    public void disableFOV() {
        this.cosFOV = 0.0;
    }

    public void setFOV(double fov) {
        this.cosFOV = Math.cos(Math.toRadians(fov));
    }

    public Set<UUID> getShown() {
        return this.shown;
    }

    public Set<UUID> getAutoHidden() {
        return this.autoHidden;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public World getWorld() {
        return this.location != null ? this.location.getWorld() : null;
    }

    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public boolean isShown(Player player) {
        return this.shown.contains(player.getUniqueId()) && !this.autoHidden.contains(player.getUniqueId());
    }

    @Override
    public NPC setLocation(Location location) {
        this.location = location;
        return this;
    }

    @Override
    public NPC create() {
        this.createPackets();
        return this;
    }

    public void onLogout(Player player) {
        this.getAutoHidden().remove(player.getUniqueId());
        this.getShown().remove(player.getUniqueId());
    }

    @Override
    public void show(Player player) {
        this.show(player, false);
    }

    public void show(Player player, boolean auto) {
        NPCShowEvent event = new NPCShowEvent(this, player, auto);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (!this.canSeeNPC(player)) {
            if (!auto) {
                this.shown.add(player.getUniqueId());
            }
            this.autoHidden.add(player.getUniqueId());
            return;
        }
        if (auto) {
            this.sendShowPackets(player);
        } else {
            if (this.isShown(player)) {
                throw new RuntimeException("Cannot call show method twice.");
            }
            if (this.shown.contains(player.getUniqueId())) {
                return;
            }
            this.shown.add(player.getUniqueId());
            if (player.getWorld().equals(this.location.getWorld()) && player.getLocation().distance(this.location) <= this.instance.getAutoHideDistance()) {
                this.sendShowPackets(player);
            } else {
                this.autoHidden.add(player.getUniqueId());
            }
        }
    }

    private boolean canSeeNPC(Player player) {
        Vector dir = this.location.toVector().subtract(player.getEyeLocation().toVector()).normalize();
        return dir.dot(player.getLocation().getDirection()) >= this.cosFOV;
    }

    @Override
    public void hide(Player player) {
        this.hide(player, false);
    }

    public void hide(Player player, boolean auto) {
        NPCHideEvent event = new NPCHideEvent(this, player, auto);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (auto) {
            this.sendHidePackets(player);
        } else {
            if (!this.shown.contains(player.getUniqueId())) {
                throw new RuntimeException("Cannot call hide method without calling NPC#show.");
            }
            this.shown.remove(player.getUniqueId());
            if (player.getWorld().equals(this.location.getWorld()) && player.getLocation().distance(this.location) <= this.instance.getAutoHideDistance()) {
                this.sendHidePackets(player);
            } else {
                this.autoHidden.remove(player.getUniqueId());
            }
        }
    }
}

