/*
 * Decompiled with CFR 0.152.
 */
package net.jitse.npclib.hologram;

import com.comphenix.tinyprotocol.Reflection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.jitse.npclib.internal.MinecraftVersion;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class Hologram {
    private final double delta = 0.3;
    private List<Object> armorStands = new ArrayList<Object>();
    private Set<Object> spawnPackets = new HashSet<Object>();
    private Set<Object> destroyPackets = new HashSet<Object>();
    private static final Class<?> CHAT_COMPONENT_TEXT_CLAZZ = Reflection.getMinecraftClass("ChatComponentText");
    private static final Class<?> CHAT_BASE_COMPONENT_CLAZZ = Reflection.getMinecraftClass("IChatBaseComponent");
    private static final Class<?> ENTITY_ARMOR_STAND_CLAZZ = Reflection.getMinecraftClass("EntityArmorStand");
    private static final Class<?> ENTITY_LIVING_CLAZZ = Reflection.getMinecraftClass("EntityLiving");
    private static final Class<?> ENTITY_CLAZZ = Reflection.getMinecraftClass("Entity");
    private static final Class<?> CRAFT_BUKKIT_CLASS = Reflection.getCraftBukkitClass("CraftWorld");
    private static final Class<?> CRAFT_PLAYER_CLAZZ = Reflection.getCraftBukkitClass("entity.CraftPlayer");
    private static final Class<?> PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CLAZZ = Reflection.getMinecraftClass("PacketPlayOutSpawnEntityLiving");
    private static final Class<?> PACKET_PLAY_OUT_ENTITY_DESTROY_CLAZZ = Reflection.getMinecraftClass("PacketPlayOutEntityDestroy");
    private static final Class<?> ENTITY_PLAYER_CLAZZ = Reflection.getMinecraftClass("EntityPlayer");
    private static final Class<?> PLAYER_CONNECTION_CLAZZ = Reflection.getMinecraftClass("PlayerConnection");
    private static final Class<?> PACKET_CLAZZ = Reflection.getMinecraftClass("Packet");
    private static final Reflection.ConstructorInvoker CHAT_COMPONENT_TEXT_CONSTRUCTOR = Reflection.getConstructor(CHAT_COMPONENT_TEXT_CLAZZ, String.class);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CLAZZ, ENTITY_LIVING_CLAZZ);
    private static final Reflection.ConstructorInvoker PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR = Reflection.getConstructor(PACKET_PLAY_OUT_ENTITY_DESTROY_CLAZZ, int[].class);
    private static final Reflection.FieldAccessor playerConnectionField = Reflection.getField(ENTITY_PLAYER_CLAZZ, "playerConnection", PLAYER_CONNECTION_CLAZZ);
    private static final Reflection.MethodInvoker SET_LOCATION_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setLocation", Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE);
    private static final Reflection.MethodInvoker SET_SMALL_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setSmall", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_INVISIBLE_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setInvisible", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_BASE_PLATE_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setBasePlate", Boolean.TYPE);
    private static final Reflection.MethodInvoker SET_ARMS_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setArms", Boolean.TYPE);
    private static final Reflection.MethodInvoker PLAYER_GET_HANDLE_METHOD = Reflection.getMethod(CRAFT_PLAYER_CLAZZ, "getHandle", new Class[0]);
    private static final Reflection.MethodInvoker SEND_PACKET_METHOD = Reflection.getMethod(PLAYER_CONNECTION_CLAZZ, "sendPacket", PACKET_CLAZZ);
    private static final Reflection.MethodInvoker GET_ID_METHOD = Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "getId", new Class[0]);
    private final Location start;
    private final List<String> lines;
    private final Object worldServer;

    public Hologram(Location location, List<String> lines) {
        this.start = location;
        this.lines = lines;
        this.worldServer = Reflection.getMethod(CRAFT_BUKKIT_CLASS, "getHandle", new Class[0]).invoke(CRAFT_BUKKIT_CLASS.cast(location.getWorld()), new Object[0]);
    }

    public void generatePackets(MinecraftVersion version) {
        Reflection.MethodInvoker gravityMethod;
        Reflection.MethodInvoker methodInvoker = gravityMethod = version.isAboveOrEqual(MinecraftVersion.V1_9_R2) ? Reflection.getMethod(ENTITY_CLAZZ, "setNoGravity", Boolean.TYPE) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setGravity", Boolean.TYPE);
        Reflection.MethodInvoker customNameMethod = version.isAboveOrEqual(MinecraftVersion.V1_12_R1) ? Reflection.getMethod(ENTITY_CLAZZ, "setCustomName", version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_BASE_COMPONENT_CLAZZ : String.class) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setCustomName", String.class);
        Reflection.MethodInvoker customNameVisibilityMethod = version.isAboveOrEqual(MinecraftVersion.V1_12_R1) ? Reflection.getMethod(ENTITY_CLAZZ, "setCustomNameVisible", Boolean.TYPE) : Reflection.getMethod(ENTITY_ARMOR_STAND_CLAZZ, "setCustomNameVisible", Boolean.TYPE);
        Location location = this.start.clone().add(0.0, 0.3 * (double)this.lines.size(), 0.0);
        Class<?> worldClass = this.worldServer.getClass().getSuperclass();
        if (this.start.getWorld().getEnvironment() != World.Environment.NORMAL) {
            worldClass = worldClass.getSuperclass();
        }
        Reflection.ConstructorInvoker entityArmorStandConstructor = version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? Reflection.getConstructor(ENTITY_ARMOR_STAND_CLAZZ, worldClass, Double.TYPE, Double.TYPE, Double.TYPE) : Reflection.getConstructor(ENTITY_ARMOR_STAND_CLAZZ, worldClass);
        for (String line : this.lines) {
            Object entityArmorStand;
            Object object = entityArmorStand = version.isAboveOrEqual(MinecraftVersion.V1_14_R1) ? entityArmorStandConstructor.invoke(this.worldServer, location.getX(), location.getY(), location.getZ()) : entityArmorStandConstructor.invoke(this.worldServer);
            if (!version.isAboveOrEqual(MinecraftVersion.V1_14_R1)) {
                SET_LOCATION_METHOD.invoke(entityArmorStand, location.getX(), location.getY(), location.getZ(), 0, 0);
            }
            customNameMethod.invoke(entityArmorStand, version.isAboveOrEqual(MinecraftVersion.V1_13_R1) ? CHAT_COMPONENT_TEXT_CONSTRUCTOR.invoke(line) : line);
            customNameVisibilityMethod.invoke(entityArmorStand, true);
            gravityMethod.invoke(entityArmorStand, version.isAboveOrEqual(MinecraftVersion.V1_9_R2));
            SET_SMALL_METHOD.invoke(entityArmorStand, true);
            SET_INVISIBLE_METHOD.invoke(entityArmorStand, true);
            SET_BASE_PLATE_METHOD.invoke(entityArmorStand, false);
            SET_ARMS_METHOD.invoke(entityArmorStand, false);
            location.subtract(0.0, 0.3, 0.0);
            if (line.isEmpty()) continue;
            this.armorStands.add(entityArmorStand);
            Object spawnPacket = PACKET_PLAY_OUT_SPAWN_ENTITY_LIVING_CONSTRUCTOR.invoke(entityArmorStand);
            this.spawnPackets.add(spawnPacket);
            Object destroyPacket = PACKET_PLAY_OUT_ENTITY_DESTROY_CONSTRUCTOR.invoke(new Object[]{new int[]{(Integer)GET_ID_METHOD.invoke(entityArmorStand, new Object[0])}});
            this.destroyPackets.add(destroyPacket);
        }
    }

    public void spawn(Player player) {
        Object playerConnection = playerConnectionField.get(PLAYER_GET_HANDLE_METHOD.invoke(CRAFT_PLAYER_CLAZZ.cast(player), new Object[0]));
        for (Object packet : this.spawnPackets) {
            SEND_PACKET_METHOD.invoke(playerConnection, packet);
        }
    }

    public void destroy(Player player) {
        Object playerConnection = playerConnectionField.get(PLAYER_GET_HANDLE_METHOD.invoke(CRAFT_PLAYER_CLAZZ.cast(player), new Object[0]));
        for (Object packet : this.destroyPackets) {
            SEND_PACKET_METHOD.invoke(playerConnection, packet);
        }
    }
}

