/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.utils;

import com.leaf.Leaf;
import com.leaf.yaml.utils.StringUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.ParameterizedType;

public class SkriptYamlUtils {
    public static File[] directoryFilter(String name, boolean root, String errorPrefix) {
        File dir = null;
        if (root) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            String server = new File("").getAbsoluteFile().getAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            Leaf.warn("[" + errorPrefix + " Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    public static <T> Class<T> getType(Class<T> c) {
        return (Class)((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()[0];
    }
}

