/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.yaml.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Checker;
import ch.njol.util.Kleenean;
import com.leaf.Leaf;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Is YAML Empty")
@Description(value={"Checks if a cached YAML file using said ID is empty.\n  - Input is the ID."})
@Examples(value={"yaml \"config\" is empty:", "\tbroadcast \"is empty\""})
@Since(value="1.1.5")
public class CondYamlIsEmpty
extends Condition {
    private Expression<String> file;

    public boolean check(final Event event) {
        return this.file.check(event, (Checker)new Checker<String>(){

            public boolean check(String s) {
                if (!Leaf.YAML_STORE.containsKey(CondYamlIsEmpty.this.file.getSingle(event))) {
                    return false;
                }
                return Leaf.YAML_STORE.get(CondYamlIsEmpty.this.file.getSingle(event)).getAllKeys().isEmpty();
            }
        }, this.isNegated());
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "yaml " + this.file.toString(event, debug) + (this.isNegated() ? " is empty" : "isn't empty");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.file = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondYamlIsEmpty.class, (String[])new String[]{"[skript-]y[a]ml %string% is empty", "[skript-]y[a]ml %string% is(n't| not) empty"});
    }
}

