/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.util;

import com.leaf.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class InventoryUtils {
    private static boolean hasClickMethod = ReflectionUtils.hasMethod(InventoryClickEvent.class, "getClickedInventory", new Class[0]);

    public static Inventory getClickedInventory(InventoryClickEvent event) {
        if (hasClickMethod) {
            return event.getClickedInventory();
        }
        if (event.getRawSlot() < 0) {
            return null;
        }
        if (event.getView().getTopInventory() != null && event.getRawSlot() < event.getView().getTopInventory().getSize()) {
            return event.getView().getTopInventory();
        }
        return event.getView().getBottomInventory();
    }

    public static Inventory getOpositiveInventory(InventoryView view, Inventory inv) {
        if (view == null || inv == null) {
            return null;
        }
        return view.getTopInventory().equals(inv) ? view.getBottomInventory() : (view.getBottomInventory().equals(inv) ? view.getTopInventory() : null);
    }

    public static int getSlotTo(Inventory invTo, ItemStack i) {
        if (i != null && invTo.first(i.getType()) >= 0) {
            for (int x = invTo.first(i.getType()); x < invTo.getSize(); ++x) {
                if (invTo.getItem(x) == null || !invTo.getItem(x).getData().equals((Object)i.getData()) || invTo.getItem(x).getAmount() >= invTo.getItem(x).getMaxStackSize()) continue;
                return x;
            }
        }
        return invTo.firstEmpty();
    }

    public static int getInvertedSlotTo(Inventory invTo, ItemStack i) {
        int x;
        for (x = 8; x >= 0; --x) {
            if (invTo.getItem(x) != null && (invTo.getItem(x) == null || !invTo.getItem(x).getData().equals((Object)i.getDurability()) || invTo.getItem(x).getAmount() >= invTo.getItem(x).getMaxStackSize())) continue;
            return x;
        }
        for (x = invTo.getSize() - 1; x > 8; --x) {
            if (invTo.getItem(x) != null && (invTo.getItem(x) == null || !invTo.getItem(x).getData().equals((Object)i.getDurability()) || invTo.getItem(x).getAmount() >= invTo.getItem(x).getMaxStackSize())) continue;
            return x;
        }
        return -1;
    }

    public static Inventory newInventory(InventoryType type, Integer size, String name) {
        size = size == null ? Integer.valueOf(type.getDefaultSize()) : Integer.valueOf(size * 9);
        if (name == null) {
            name = type.getDefaultTitle();
        } else if (name.length() > 32) {
            name = name.substring(0, 32);
        }
        switch (type) {
            case BEACON: 
            case MERCHANT: 
            case CRAFTING: 
            case CREATIVE: {
                return null;
            }
            case CHEST: {
                return Bukkit.getServer().createInventory(null, size.intValue(), name);
            }
            case DROPPER: {
                type = InventoryType.DISPENSER;
            }
        }
        return Bukkit.getServer().createInventory(null, type, name);
    }
}

