/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.db;

import ch.njol.skript.Skript;
import ch.njol.skript.effects.Delay;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.Leaf;
import com.github.leafsk.leaf.db.ExprUnsafe;
import com.github.leafsk.leaf.util.SkriptUtil;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import javax.sql.rowset.CachedRowSet;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class EffExecuteStatement
extends Delay {
    static String lastError;
    private static final ExecutorService threadPool;
    private Expression<String> query;
    private Expression<HikariDataSource> dataSource;
    private VariableString var;
    private boolean isLocal;
    private boolean isList;

    static {
        Skript.registerEffect(EffExecuteStatement.class, (String[])new String[]{"execute %string% (in|on) %datasource% [and store [[the] (output|result)[s]] (to|in) [the] [var[iable]] %-objects%]"});
        threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    }

    protected void execute(Event e) {
        CompletableFuture<String> sql = CompletableFuture.supplyAsync(() -> this.executeStatement(e), threadPool);
        sql.whenComplete((res, err) -> {
            if (err != null) {
                err.printStackTrace();
            }
            Bukkit.getScheduler().runTask((Plugin)Leaf.getInstance(), () -> {
                lastError = res;
                if (this.getNext() != null) {
                    TriggerItem.walk((TriggerItem)this.getNext(), (Event)e);
                }
            });
        });
    }

    protected TriggerItem walk(Event e) {
        this.debug(e, true);
        SkriptUtil.delay(e);
        this.execute(e);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeStatement(Event e) {
        HikariDataSource ds = (HikariDataSource)this.dataSource.getSingle(e);
        if (ds == null) {
            return "Data source is not set";
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                Connection conn = ds.getConnection();
                try {
                    try (PreparedStatement stmt = this.createStatement(e, conn);){
                        boolean hasResultSet = stmt.execute();
                        if (this.var != null) {
                            String baseVariable = this.var.toString(e).toLowerCase(Locale.ENGLISH);
                            if (this.isList) {
                                baseVariable = baseVariable.substring(0, baseVariable.length() - 1);
                            }
                            if (hasResultSet) {
                                CachedRowSet crs = Leaf.getRowSetFactory().createCachedRowSet();
                                crs.populate(stmt.getResultSet());
                                if (this.isList) {
                                    this.populateVariable(e, crs, baseVariable);
                                } else {
                                    crs.last();
                                    this.setVariable(e, baseVariable, crs.getRow());
                                }
                            } else if (!this.isList) {
                                this.setVariable(e, baseVariable, stmt.getUpdateCount());
                            }
                        }
                    }
                    if (conn == null) return null;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return null;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            return ex.getMessage();
        }
    }

    private PreparedStatement createStatement(Event e, Connection conn) throws SQLException {
        Object[] objects;
        if (!(this.query instanceof VariableString)) {
            return conn.prepareStatement((String)this.query.getSingle(e));
        }
        if (((VariableString)this.query).isSimple()) {
            return conn.prepareStatement(SkriptUtil.getSimpleString((VariableString)this.query));
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> parameters = new ArrayList<Object>();
        Object[] objectArray = objects = SkriptUtil.getTemplateString((VariableString)this.query);
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof String) {
                sb.append(o);
            } else {
                Expression<?> expr = SkriptUtil.getExpressionFromInfo(o);
                if (expr instanceof ExprUnsafe) {
                    sb.append(expr.getSingle(e));
                } else {
                    parameters.add(expr.getSingle(e));
                    sb.append('?');
                }
            }
            ++n2;
        }
        PreparedStatement stmt = conn.prepareStatement(sb.toString());
        int i = 0;
        while (i < parameters.size()) {
            stmt.setObject(i + 1, parameters.get(i));
            ++i;
        }
        return stmt;
    }

    private void setVariable(Event e, String name, Object obj) {
        Variables.setVariable((String)name.toLowerCase(Locale.ENGLISH), (Object)obj, (Event)e, (boolean)this.isLocal);
    }

    private void populateVariable(Event e, CachedRowSet crs, String baseVariable) throws SQLException {
        ResultSetMetaData meta = crs.getMetaData();
        int columnCount = meta.getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            String label = meta.getColumnLabel(i);
            this.setVariable(e, String.valueOf(baseVariable) + label, label);
            ++i;
        }
        int rowNumber = 1;
        while (crs.next()) {
            int i2 = 1;
            while (i2 <= columnCount) {
                this.setVariable(e, String.valueOf(baseVariable) + meta.getColumnLabel(i2).toLowerCase(Locale.ENGLISH) + "::" + rowNumber, crs.getObject(i2));
                ++i2;
            }
            ++rowNumber;
        }
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "execute " + this.query.toString(e, debug) + " in " + this.dataSource.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        Expression<?> statementExpr = exprs[0];
        if (!(statementExpr instanceof VariableString) && !(statementExpr instanceof ExprUnsafe)) {
            Skript.error((String)"Database statements must be string literals. If you must use an expression, you may use \"%unsafe (your expression)%\", but keep in mind, you may be vulnerable to SQL injection attacks!");
            return false;
        }
        this.query = statementExpr;
        this.dataSource = exprs[1];
        Expression<?> expr = exprs[2];
        if (expr instanceof Variable) {
            Variable varExpr = (Variable)expr;
            this.var = SkriptUtil.getVariableName(varExpr);
            this.isLocal = varExpr.isLocal();
            this.isList = varExpr.isList();
        } else if (expr != null) {
            Skript.error((String)(expr + " is not a variable"));
            return false;
        }
        return true;
    }
}

