/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.util;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.command.Argument;
import ch.njol.skript.command.Commands;
import ch.njol.skript.config.Config;
import ch.njol.skript.config.Node;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.lang.TriggerSection;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.log.LogEntry;
import ch.njol.skript.log.RetainingLogHandler;
import ch.njol.skript.log.SkriptLogger;
import ch.njol.skript.variables.Variables;
import com.github.leafsk.leaf.util.ReflectionUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;

public class Evaluate {
    private static Evaluate ourInstance = new Evaluate();
    private Pattern[] filterSyntaxes = null;
    private Predicate<String> comparator = null;

    public static Evaluate getInstance() {
        return ourInstance;
    }

    private Evaluate() {
    }

    public void parseConfig(FileConfiguration config) {
        List syntaxes = config.getStringList("evaluate_filter.syntaxes");
        if (syntaxes == null || syntaxes.size() == 0) {
            return;
        }
        this.comparator = config.getString("evaluate_filter.mode").equalsIgnoreCase("whitelist") ? s -> {
            Pattern[] patternArray = this.filterSyntaxes;
            int n = this.filterSyntaxes.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern p = patternArray[n2];
                if (p.matcher((CharSequence)s).find()) {
                    return true;
                }
                ++n2;
            }
            return false;
        } : s -> {
            Pattern[] patternArray = this.filterSyntaxes;
            int n = this.filterSyntaxes.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern p = patternArray[n2];
                if (p.matcher((CharSequence)s).find()) {
                    return false;
                }
                ++n2;
            }
            return true;
        };
        this.filterSyntaxes = new Pattern[syntaxes.size()];
        int index = 0;
        for (String str : syntaxes) {
            str = "(?i).*" + str.replaceAll("%.+?%", ".+?").replaceAll("\\[(.+?)]", "($1)?").replaceAll("\\s+", "\\\\s+") + ".*";
            this.filterSyntaxes[index++] = Pattern.compile(str);
        }
    }

    public void evaluate(String code, Event e, Variable results, boolean parseString, Config currentScript, List<Argument<?>> args, TriggerItem source, boolean runWithSafety) {
        if (code != null && !code.isEmpty()) {
            RetainingLogHandler log = SkriptLogger.startRetainingLog();
            try {
                try {
                    Commands.currentArguments = args;
                    if (parseString) {
                        ScriptLoader.currentScript = currentScript;
                        VariableString vs = VariableString.newInstance((String)code.replaceAll("\"", "\"\""));
                        if (vs != null) {
                            code = vs.getSingle(e);
                        }
                    }
                    code = code.replaceAll("\\\\n(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)", "\n").replaceAll("\\\\t(?=[^\"]*(?:\"[^\"]*\"[^\"]*)*$)", "\t");
                    Config c = new Config(code, "LeafSK/evaluate.sk", true, false, ":");
                    ReflectionUtils.setField(c.getClass(), c, "file", (Object)new File("LeafSK/evaluate.sk"));
                    SectionNode node = c.getMainNode();
                    if (runWithSafety && this.filterSyntaxes != null) {
                        ArrayList<Node> toRemove = new ArrayList<Node>();
                        for (Node n : node) {
                            if (this.comparator.test(n.getKey())) continue;
                            log.log(new LogEntry(Level.SEVERE, "You don't have permission to use: " + n.getKey()));
                            toRemove.add(n);
                        }
                        toRemove.forEach(Node::remove);
                    }
                    ScriptLoader.currentScript = c;
                    ScriptLoader.setCurrentEvent((String)"evaluate effect", (Class[])new Class[]{e.getClass()});
                    TriggerSection ts = new TriggerSection(c.getMainNode()){

                        protected TriggerItem walk(Event event) {
                            return this.walk(event, true);
                        }

                        public String toString(Event event, boolean b) {
                            return "evaluate effect";
                        }
                    };
                    ScriptLoader.deleteCurrentEvent();
                    ScriptLoader.currentScript = null;
                    Commands.currentArguments = null;
                    this.setVariable(log, e, results);
                    TriggerItem.walk((TriggerItem)ts, (Event)e);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.stop();
                }
            }
            finally {
                log.stop();
            }
        }
    }

    public void setVariable(RetainingLogHandler log, Event e, Variable results) {
        if (results != null) {
            int x = 1;
            String name = ((VariableString)ReflectionUtils.getField(Variable.class, results, "name")).getSingle(e).toLowerCase();
            String varName = name.substring(0, name.length() - 1);
            for (LogEntry lg : log.getErrors()) {
                Variables.setVariable((String)(String.valueOf(varName) + x++), (Object)lg.getMessage(), (Event)e, (boolean)results.isLocal());
            }
        }
    }
}

