/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.effects;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.util.Registry;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.Firework;
import org.bukkit.event.Event;
import org.bukkit.inventory.meta.FireworkMeta;

public class EffFirework
extends Effect {
    Random random = new Random();
    private Expression<String> type;
    private Expression<Location> locations;
    private Expression<Number> time;
    private Expression<String> multiColours;
    private Expression<ch.njol.skript.util.Color> colour;

    static {
        Registry.newEffect(EffFirework.class, "(launch|deploy) [%-strings%] firework[s] at %locations% [with] (duration|timed|time) %number% [colo[u]r[ed] (%-strings%|%-color%)]");
    }

    public boolean init(Expression<?>[] e, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.type = e[0];
        this.locations = e[1];
        this.time = e[2];
        this.multiColours = e[3];
        this.colour = e[4];
        return true;
    }

    public String toString(@Nullable Event paramEvent, boolean paramBoolean) {
        return "(launch|deploy) [%-string%] firework[s] at %locations% [with] (duration|timed|time) %number% [colo[u]r[ed] (%-strings%|%-color%)]";
    }

    protected void execute(Event e) {
        int r = this.random.nextInt(17) + 1;
        Color finalColour = this.getColor(r);
        if (this.colour != null) {
            ch.njol.skript.util.Color c = ch.njol.skript.util.Color.byName((String)((ch.njol.skript.util.Color)this.colour.getSingle(e)).toString());
            finalColour = c.getBukkitColor();
        }
        FireworkEffect.Type t = this.randomType();
        if (this.type != null) {
            t = FireworkEffect.Type.valueOf((String)((String)this.type.getSingle(e)).replace("\"", "").trim().replace(" ", "_").toUpperCase());
            try {
                FireworkEffect.Type.valueOf((String)t.toString().replace("\"", "").trim().replace(" ", "_").toUpperCase());
            }
            catch (IllegalArgumentException e1) {
                return;
            }
        }
        Location[] locationArray = (Location[])this.locations.getAll(e);
        int n = locationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Location l = locationArray[n2];
            Firework firework = (Firework)l.getWorld().spawn(l, Firework.class);
            FireworkMeta meta = firework.getFireworkMeta();
            if (this.multiColours != null || finalColour == null) {
                String[] stringArray = (String[])this.multiColours.getAll(e);
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String s = stringArray[n4];
                    if (this.type == null) {
                        FireworkEffect.Type randomType = this.randomType();
                        meta.addEffect(FireworkEffect.builder().withColor(ch.njol.skript.util.Color.byName((String)s.toString()).getBukkitColor()).with(randomType).build());
                    } else {
                        meta.addEffect(FireworkEffect.builder().withColor(ch.njol.skript.util.Color.byName((String)s.toString()).getBukkitColor()).with(t).build());
                    }
                    ++n4;
                }
            } else {
                meta.addEffect(FireworkEffect.builder().withColor(finalColour).with(t).build());
            }
            meta.setPower(((Number)this.time.getSingle(e)).intValue());
            firework.setFireworkMeta(meta);
            ++n2;
        }
    }

    private FireworkEffect.Type randomType() {
        int i = this.random.nextInt(5) + 1;
        FireworkEffect.Type type = null;
        if (i == 1) {
            type = FireworkEffect.Type.BALL;
        } else if (i == 2) {
            type = FireworkEffect.Type.BALL_LARGE;
        } else if (i == 3) {
            type = FireworkEffect.Type.BURST;
        } else if (i == 4) {
            type = FireworkEffect.Type.CREEPER;
        } else if (i == 5) {
            type = FireworkEffect.Type.STAR;
        }
        return type;
    }

    private Color getColor(int i) {
        Color c = null;
        if (i == 1) {
            c = Color.AQUA;
        } else if (i == 2) {
            c = Color.BLACK;
        } else if (i == 3) {
            c = Color.BLUE;
        } else if (i == 4) {
            c = Color.FUCHSIA;
        } else if (i == 5) {
            c = Color.GRAY;
        } else if (i == 6) {
            c = Color.GREEN;
        } else if (i == 7) {
            c = Color.LIME;
        } else if (i == 8) {
            c = Color.MAROON;
        } else if (i == 9) {
            c = Color.NAVY;
        } else if (i == 10) {
            c = Color.OLIVE;
        } else if (i == 11) {
            c = Color.ORANGE;
        } else if (i == 12) {
            c = Color.PURPLE;
        } else if (i == 13) {
            c = Color.RED;
        } else if (i == 14) {
            c = Color.SILVER;
        } else if (i == 15) {
            c = Color.TEAL;
        } else if (i == 16) {
            c = Color.WHITE;
        } else if (i == 17) {
            c = Color.YELLOW;
        }
        return c;
    }
}

