/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.lang.ExpressionType;
import com.github.leafsk.leaf.expressions.ExprItemNBT;
import com.github.leafsk.leaf.expressions.ExprNBTOf;
import com.github.leafsk.leaf.manager.gui.GUIManager;
import com.github.leafsk.leaf.manager.gui.v2.SkriptGUIEvent;
import com.github.leafsk.leaf.nbt.NMSInterface;
import com.github.leafsk.leaf.nbt.NMS_v1_10_R1;
import com.github.leafsk.leaf.nbt.NMS_v1_11_R1;
import com.github.leafsk.leaf.nbt.NMS_v1_12_R1;
import com.github.leafsk.leaf.nbt.NMS_v1_8_R3;
import com.github.leafsk.leaf.nbt.NMS_v1_9_R1;
import com.github.leafsk.leaf.nbt.NMS_v1_9_R2;
import com.github.leafsk.leaf.util.EnumClassInfo;
import com.github.leafsk.leaf.util.ReflectionUtils;
import com.github.leafsk.leaf.util.Registry;
import com.github.leafsk.leaf.utils.yaml.YAMLProcessor;
import java.util.HashMap;
import java.util.logging.Level;
import javax.sql.rowset.RowSetFactory;
import javax.sql.rowset.RowSetProvider;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Leaf
extends JavaPlugin {
    public static Leaf plugin;
    private static GUIManager gui;
    private static RowSetFactory rowSetFactory;
    public static final HashMap<String, YAMLProcessor> YAML_STORE;
    private static NMSInterface nmsMethods;

    static {
        YAML_STORE = new HashMap();
    }

    public Leaf() {
        if (plugin != null) {
            throw new IllegalStateException("LeafSK can't have two instances.");
        }
        plugin = this;
    }

    public void onEnable() {
        Boolean hasSkript = this.hasPlugin("Skript");
        if (!hasSkript.booleanValue() || !Skript.isAcceptRegistrations()) {
            if (!hasSkript.booleanValue()) {
                Leaf.log("Error 404 - Skript not found.", Level.SEVERE);
            } else {
                Leaf.log("LeafSK can't be loaded when the server is already loaded.", Level.SEVERE);
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("SkQuery") == null) {
            EnumClassInfo.create(Sound.class, "sound").register();
        }
        if (this.setupNMSVersion()) {
            Registry.newSimple(ExprItemNBT.class, "%itemstack% with [custom] nbt[[ ]tag[s]] %string%");
            Skript.registerExpression(ExprNBTOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt[[ ]tag[s]] of %~object%", "%~object%'s nbt[[ ]tag[s]]"});
        }
        SkriptAddon leaf = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        try {
            rowSetFactory = RowSetProvider.newFactory();
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"register", "conditions", "effects", "sections", "expressions", "Stylishboards", "db", "events", "yaml"});
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"papi"});
            }
            if (Bukkit.getPluginManager().getPlugin("NametagEdit") != null) {
                leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"nte"});
            }
            if (Bukkit.getPluginManager().getPlugin("ASkyBlock") != null) {
                leaf.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"asb"});
            }
        }
        catch (Exception e) {
            this.info("Error while registering stuff", new Object[0]);
            e.printStackTrace();
        }
    }

    public void onDisable() {
        SkriptGUIEvent.getInstance().unregisterAll();
        if (gui != null) {
            gui.clearAll();
        }
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public static Leaf getInstance() {
        return plugin;
    }

    public boolean hasPlugin(String str) {
        return plugin.getServer().getPluginManager().isPluginEnabled(str);
    }

    public void info(String msg, Object ... values) {
        Leaf.log(String.format(msg, values), Level.INFO);
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(Leaf.getInstance());
        }
        return gui;
    }

    public static void log(String msg) {
        Leaf.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static void log(Level lvl, String ... msgs) {
        String[] stringArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            Leaf.log(msg, lvl);
            ++n2;
        }
    }

    public static boolean debug() {
        return plugin.getConfig().getBoolean("debug_mode");
    }

    public static void debug(Object ... objects) {
        if (!Leaf.debug()) {
            return;
        }
        StackTraceElement caller = new Exception().getStackTrace()[1];
        Leaf.log(String.format("\u00a7aLeakSk: [%s, line %s] %s", caller.getFileName(), caller.getLineNumber(), StringUtils.join((Object[])objects, (String)" || ")));
    }

    public static boolean isSpigot() {
        return ReflectionUtils.hasMethod(Player.class, "spigot", new Class[0]);
    }

    private boolean setupNMSVersion() {
        String version = ReflectionUtils.getVersion();
        if (version.equals("v1_8_R3.")) {
            nmsMethods = new NMS_v1_8_R3();
        } else if (version.equals("v1_9_R1.")) {
            nmsMethods = new NMS_v1_9_R1();
        } else if (version.equals("v1_9_R2.")) {
            nmsMethods = new NMS_v1_9_R2();
        } else if (version.equals("v1_10_R1.")) {
            nmsMethods = new NMS_v1_10_R1();
        } else if (version.equals("v1_11_R1.")) {
            nmsMethods = new NMS_v1_11_R1();
        } else if (version.equals("v1_12_R1.")) {
            nmsMethods = new NMS_v1_12_R1();
        }
        return nmsMethods != null;
    }

    public static NMSInterface getNMSMethods() {
        return nmsMethods;
    }

    public static RowSetFactory getRowSetFactory() {
        return rowSetFactory;
    }
}

