/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.yaml;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.leafsk.leaf.Leaf;
import com.github.leafsk.leaf.utils.yaml.YAMLProcessor;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

public class ExprYamlComments
extends SimpleExpression<Object> {
    private Expression<String> paths;
    private Expression<String> file;
    private int mark;
    private States state;

    static {
        Skript.registerExpression(ExprYamlComments.class, Object.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] comment[s] (of|from) [y[a]ml] node[s] %strings% (of|in|from) %string% [(1\u00a6with [an] extra line)]", "[the] (comment[s] (at|on) [the] top of |header (of|from)) %string% [(1\u00c2\u00a6with [an] extra line)]"});
    }

    public Class<? extends Object> getReturnType() {
        return Object.class;
    }

    public boolean isSingle() {
        return false;
    }

    public String toString(@Nullable Event event, boolean b) {
        return String.valueOf(this.state.toString().toLowerCase()) + (this.state == States.COMMENT ? " for path " + this.paths.toString(event, b) : "") + " from yaml " + this.file.toString(event, b);
    }

    @Nullable
    protected Object[] get(Event event) {
        String name = (String)this.file.getSingle(event);
        String path = (String)this.paths.getSingle(event);
        if (!Leaf.YAML_STORE.containsKey(name)) {
            Leaf.log("No yaml by the name '" + name + "' has been loaded");
            return null;
        }
        YAMLProcessor config = Leaf.YAML_STORE.get(name);
        if (this.state == States.COMMENT) {
            String comment = config.getComment(path);
            if (comment == null) {
                return null;
            }
            List<String> comments = Arrays.asList(comment.split("\\r?\\n"));
            return comments.toArray(new String[comments.size()]);
        }
        if (this.state == States.HEADER) {
            String header = config.getHeader();
            if (header == null) {
                return null;
            }
            List<String> comments = Arrays.asList(header.split("\\r?\\n"));
            return comments.toArray(new String[comments.size()]);
        }
        return null;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        String name = (String)this.file.getSingle(event);
        String[] paths = null;
        if (!Leaf.YAML_STORE.containsKey(name)) {
            Leaf.log("No yaml by the name '" + name + "' has been loaded");
            return;
        }
        YAMLProcessor config = Leaf.YAML_STORE.get(name);
        if (this.state == States.COMMENT) {
            paths = (String[])this.paths.getAll(event);
            if (mode == Changer.ChangeMode.SET) {
                String[] comments = new String[delta.length];
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (!p.contains(".")) {
                        if (config.getMap().containsKey(p)) {
                            config.setComment(p, this.mark == 1, this.toStringArray(delta, comments));
                        } else {
                            Leaf.log("'" + p + "' is not a valid path in '" + name + "'");
                        }
                    } else {
                        Leaf.log("Comments can only be added to root paths not '" + p + "' in '" + name + "'");
                    }
                    ++n2;
                }
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                String[] stringArray = paths;
                int n = paths.length;
                int n3 = 0;
                while (n3 < n) {
                    String p = stringArray[n3];
                    if (config.getMap().containsKey(p)) {
                        String n4 = null;
                        config.setComment(p, false, n4);
                    }
                    ++n3;
                }
            }
        } else if (this.state == States.HEADER) {
            if (mode == Changer.ChangeMode.SET) {
                config.setHeader(this.toStringArray(delta, new String[delta.length]));
                config.setExtraHeaderLine(this.mark == 1);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                String n = null;
                config.setHeader(n);
                config.setExtraHeaderLine(false);
            }
        }
    }

    private String[] toStringArray(Object[] input, String[] output) {
        int i = 0;
        while (i < input.length) {
            output[i] = (String)input[i];
            ++i;
        }
        return output;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Object[].class});
        }
        return null;
    }

    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        if (matchedPattern == 0) {
            this.state = States.COMMENT;
            this.paths = e[0];
            this.file = e[1];
        } else {
            this.state = States.HEADER;
            this.file = e[0];
        }
        this.mark = parse.mark;
        return true;
    }

    private static enum States {
        COMMENT,
        HEADER;

    }
}

