/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.yaml;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.Leaf;
import com.github.leafsk.leaf.util.StringUtil;
import com.github.leafsk.leaf.utils.yaml.YAMLFormat;
import com.github.leafsk.leaf.utils.yaml.YAMLProcessor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Load all YAML from directory")
@Description(value={"Loads a directory YAML files into memory.\n  - The input is a directory (ie. \"plugins/MyAwesomePlugin/\").\n  - If for example a file in that directory is named test.yml then the output ID would be 'plugins/MyAwesomePlugin/test.yml'\n  - Using the optional filename ID would output `test.yml`"})
@Examples(value={"#This isn't something you would really want to do, or is it?", "load all yaml from directory \"/plugins/skript-yaml/test\"", "loop all of the currently loaded yaml files:", "\tloop yaml nodes \"\" from loop-value-1:", "\t\tloop yaml nodes loop-value-2 from loop-value-1:", "\t\t\tbroadcast yaml value \"%loop-value-2%.%loop-value-3%\" from loop-value-1"})
@Since(value="1.2")
public class EffLoadYamlDirectory
extends Effect {
    private Expression<String> file;
    private int mark;
    private int matchedPattern;

    static {
        Skript.registerEffect(EffLoadYamlDirectory.class, (String[])new String[]{"[re]load all [y[a]ml] from [(1\u00c2\u00a6non[(-| )]relative)] director(y|ies) %strings%", "[re]load all [y[a]ml] from [(1\u00c2\u00a6non[(-| )]relative)] director(y|ies) %strings% using [the] filename as [the] id"});
    }

    public File[] filter(String name) {
        File dir = null;
        if (this.mark == 1) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            Leaf.log("[Load Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    protected void execute(@Nullable Event event) {
        String[] stringArray = (String[])this.file.getAll(event);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File[] fileArray = this.filter(StringUtil.checkSeparator(name));
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                block13: {
                    File yamlFile = fileArray[n4];
                    YAMLProcessor yaml = new YAMLProcessor(yamlFile, false, YAMLFormat.EXTENDED);
                    try {
                        try {
                            yaml.load();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            if (this.matchedPattern == 1) {
                                Leaf.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                            } else {
                                Leaf.YAML_STORE.put(String.valueOf(StringUtil.checkLastSeparator(name)) + yamlFile.getName(), yaml);
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.matchedPattern == 1) {
                            Leaf.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                        } else {
                            Leaf.YAML_STORE.put(String.valueOf(StringUtil.checkLastSeparator(name)) + yamlFile.getName(), yaml);
                        }
                        throw throwable;
                    }
                    if (this.matchedPattern == 1) {
                        Leaf.YAML_STORE.put(StringUtil.stripExtention(yamlFile.getName()), yaml);
                    } else {
                        Leaf.YAML_STORE.put(String.valueOf(StringUtil.checkLastSeparator(name)) + yamlFile.getName(), yaml);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "[re]load all yaml from director(y|ies) " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.mark = parse.mark;
        this.matchedPattern = matchedPattern;
        return true;
    }
}

