/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.yaml;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.Leaf;
import com.github.leafsk.leaf.util.StringUtil;
import com.github.leafsk.leaf.utils.yaml.AsyncEffectOld;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nullable;
import org.bukkit.event.Event;

@Name(value="Delete all YAML from directory")
@Description(value={"Deletes a directory of YAML files and removes them from memory.\n  - The input is a directory (ie. \"plugins/MyAwesomePlugin/\").\n  - If for example a file in that directory is named test.yml then the output ID would be 'plugins/MyAwesomePlugin/test.yml'\n  - Using the optional filename ID would output `test.yml`"})
@Examples(value={"delete all yaml from directory \"/plugins/skript-yaml/test\""})
@Since(value="1.2.1")
public class EffDeleteYamlFromDirectory
extends AsyncEffectOld {
    private Expression<String> file;
    private int mark;

    static {
        Skript.registerEffect(EffDeleteYamlFromDirectory.class, (String[])new String[]{"delete all [y[a]ml] from [(1\u00c2\u00a6non[(-| )]relative)] director(y|ies) %strings%"});
    }

    public File[] filter(String name) {
        File dir = null;
        if (this.mark == 1) {
            dir = new File(StringUtil.checkRoot(name));
        } else {
            Path server = Paths.get("", new String[0]).normalize().toAbsolutePath();
            dir = new File(server + File.separator + name);
        }
        if (!dir.isDirectory()) {
            Leaf.log("[Delete Yaml] " + name + " is not a directory!");
            return null;
        }
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                return filename.endsWith(".yml") | filename.endsWith(".yaml");
            }
        });
    }

    protected void execute(@Nullable Event event) {
        String[] stringArray = (String[])this.file.getAll(event);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File[] fileArray = this.filter(StringUtil.checkSeparator(name));
            int n3 = fileArray.length;
            int n4 = 0;
            while (n4 < n3) {
                File yamlFile = fileArray[n4];
                yamlFile.delete();
                ++n4;
            }
            ++n2;
        }
    }

    public String toString(@Nullable Event event, boolean b) {
        return "delete all yaml from director(y|ies) " + this.file.toString(event, b);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parse) {
        this.file = exprs[0];
        this.mark = parse.mark;
        return true;
    }
}

