/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.sections.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.manager.gui.v2.GUIHandler;
import com.github.leafsk.leaf.manager.gui.v2.GUIInventory;
import com.github.leafsk.leaf.sections.gui.EffCreateGUI;
import com.github.leafsk.leaf.util.EffectSection;
import com.github.leafsk.leaf.util.Registry;
import com.github.leafsk.leaf.util.VariableUtil;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

@Name(value="Make GUI")
@Description(value={"Used to format a gui slot inside of gui creation/editing section"})
public class EffMakeGUI
extends EffectSection {
    public static EffMakeGUI lastInstance;
    private Expression<?> slot;
    private Expression<ItemStack> item;
    private int type;

    static {
        Registry.newEffect(EffMakeGUI.class, "(make|format) next gui [slot] (with|to) %itemstack%", "(make|format) gui [slot] %strings/numbers% (with|to) %itemstack%", "(un(make|format)|remove) next gui [slot]", "(un(make|format)|remove) gui [slot] %strings/numbers%", "(un(make|format)|remove) all gui [slot]");
        lastInstance = null;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (EffMakeGUI.getCurrentSection(EffCreateGUI.class) == null) {
            Skript.error((String)"You can't make a gui outside of 'create/edit gui' effect.");
            return false;
        }
        this.type = arg1++;
        if (arg.length > 0 && arg1 <= 2) {
            this.item = arg[arg.length - 1];
        }
        if (arg1 % 2 == 0) {
            this.slot = arg[0].getConvertedExpression(new Class[]{Object.class});
        }
        if (this.hasSection()) {
            this.loadSection("gui effect", false, InventoryClickEvent.class);
        }
        return true;
    }

    @Override
    public void execute(Event e) {
        Object[] slot;
        Object[] objectArray;
        GUIInventory gui = GUIHandler.getInstance().getGUIEvent(e);
        if (gui == null) {
            return;
        }
        if (this.type > 1) {
            Object[] objectArray2;
            if (this.slot != null) {
                objectArray2 = this.slot.getArray(e);
            } else if (this.type == 4) {
                objectArray2 = null;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray2 = objectArray3;
                objectArray3[0] = Character.valueOf(gui.nextInvertedSlot());
            }
            Object[] slots = objectArray2;
            gui.clearSlots(slots);
            return;
        }
        ItemStack item = (ItemStack)this.item.getSingle(e);
        if (this.slot != null) {
            objectArray = this.slot.getArray(e);
        } else {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = Character.valueOf(gui.nextSlot());
        }
        Object[] objectArray5 = slot = objectArray;
        int n = slot.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray5[n2];
            if (this.hasSection()) {
                Object variables = VariableUtil.getInstance().copyVariables(e);
                gui.setItem(s, item, event -> {
                    VariableUtil.getInstance().pasteVariables((Event)event, variables);
                    GUIHandler.getInstance().setGUIEvent((Event)event, gui);
                    this.runSection((Event)event);
                });
            } else {
                gui.setItem(s, item);
            }
            ++n2;
        }
    }

    public String toString(Event arg0, boolean arg1) {
        if (this.type > 1) {
            return "unmake gui slot";
        }
        return "make " + (this.slot != null ? " a gui slot " + this.slot.toString(arg0, arg1) : "next gui slot") + " of gui with " + this.item.toString(arg0, arg1);
    }
}

