/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.sections.gui;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.manager.gui.v2.GUIHandler;
import com.github.leafsk.leaf.manager.gui.v2.GUIInventory;
import com.github.leafsk.leaf.manager.gui.v2.SkriptGUIEvent;
import com.github.leafsk.leaf.util.LazyEffectSection;
import com.github.leafsk.leaf.util.Registry;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

@Name(value="Create a GUI")
@Description(value={"It creates a new gui with a given id (optional), using a base inventory, and a shape (optional)", "For more info, read the [here](https://github.com/Tuke-Nuke/TuSKe/wiki/GUI-Manager)"})
@Examples(value={"on skript load:", "\tcreate a gui with id \"LobbySelector\" with virtual chest with 4 rows named \"&4Lobby Selector\":", "\t\tmake gui slot 2 with diamond sword named \"PVP\":", "\t\t\texecute player command \"/server pvp\" #'on skript load' event doesn't have a 'player', but it will recognize it as it does have.", "\t\tmake gui slot 4 with grass named \"SkyBlock\":", "\t\t\texecute player command \"/server skyblock\"", " ", "command /lobby:", "\ttrigger:", "\t\topen gui \"LobbySelector\" to player"})
@Since(value="1.7.5")
public class EffCreateGUI
extends LazyEffectSection {
    private Expression<GUIInventory> exprGui;
    private Expression<Inventory> inv;
    private Expression<String> str;
    private Expression<String> id;

    static {
        Registry.newEffect(EffCreateGUI.class, "create [a] [new] gui [[with id] %-string%] with %inventory% [and shape %-strings%]", "(change|edit) %guiinventory%");
    }

    @Override
    public void execute(Event e) {
        GUIHandler.getInstance().setGUIEvent(e, null);
        if (this.exprGui == null) {
            Inventory inv = (Inventory)this.inv.getSingle(e);
            if (inv != null) {
                String id;
                GUIInventory gui = new GUIInventory(inv);
                if (this.str != null) {
                    gui.shape((String[])this.str.getArray(e));
                } else {
                    gui.shapeDefault();
                }
                String string = id = this.id != null ? (String)this.id.getSingle(e) : null;
                if (id != null && !id.isEmpty()) {
                    GUIHandler.getInstance().setGUI(id, gui);
                }
                GUIHandler.getInstance().setGUIEvent(e, gui);
            }
        } else {
            GUIInventory gui = (GUIInventory)this.exprGui.getSingle(e);
            if (gui != null) {
                GUIHandler.getInstance().setGUIEvent(e, gui);
            }
        }
    }

    public String toString(Event event, boolean b) {
        return "create gui";
    }

    public boolean init(Expression<?>[] arg, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (this.checkIfCondition()) {
            return false;
        }
        if (i > 0) {
            if (!this.hasSection()) {
                Skript.error((String)"You can't edit a gui inventory using an empty section, you need to change at least a slot or a property.");
                return false;
            }
            this.exprGui = arg[0];
        } else {
            this.id = arg[0];
            this.inv = arg[1];
            this.str = arg[2];
        }
        SkriptGUIEvent.getInstance().register();
        return true;
    }
}

