/*
 * Decompiled with CFR 0.152.
 */
package com.github.leafsk.leaf.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.leafsk.leaf.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.event.Event;
import org.bukkit.util.ChatPaginator;

@Name(value="Split Characters")
@Description(value={"Split a text with {{types|Number|number}} amount of characters. It is used to split the message in chat (the default is 60) and to item's lore."})
@Examples(value={"set {_s::*} to split \"Hi, this text will be splitted in 3 lines\" by 10 characters"})
@Since(value="1.6.8")
public class ExprSplitCharacter
extends SimpleExpression<String> {
    private Expression<String> str;
    private Expression<Number> id;

    static {
        Registry.newSimple(ExprSplitCharacter.class, "split %string% (with|by|using) %number% [char[acter][s]]", "%string% [split] (with|by|using) %number% [char[acter][s]]");
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public boolean isSingle() {
        return false;
    }

    public boolean init(Expression<?>[] arg, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.str = arg[0];
        this.id = arg[1];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return null;
    }

    @Nullable
    protected String[] get(Event e) {
        if (this.str.getSingle(e) == null || this.id.getSingle(e) == null) {
            return null;
        }
        return ChatPaginator.wordWrap((String)((String)this.str.getSingle(e)), (int)((Number)this.id.getSingle(e)).intValue());
    }
}

