/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.manager.gui.v2;

import ch.njol.skript.Skript;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.listeners.GUIListener;
import com.github.tukenuke.tuske.manager.gui.v2.GUIHandler;
import com.github.tukenuke.tuske.util.InventoryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class GUIInventory {
    private static final Consumer<InventoryClickEvent> nullConsumer = e -> {};
    private String rawShape;
    private Map<Character, Consumer<InventoryClickEvent>> slots = new HashMap<Character, Consumer<InventoryClickEvent>>();
    private Map<Character, ItemStack> items = new HashMap<Character, ItemStack>();
    private Consumer<InventoryCloseEvent> onClose;
    private Inventory inv;
    private GUIListener listener;
    private boolean isLocked = false;

    public GUIInventory(Inventory inv) {
        this.inv = inv;
    }

    public GUIInventory setID(String id) {
        return this;
    }

    public GUIInventory shape(String ... shapes) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = shapes;
        int n = shapes.length;
        int n2 = 0;
        while (n2 < n) {
            String shape = stringArray[n2];
            sb.append(shape);
            ++n2;
        }
        while (sb.length() < this.inv.getSize()) {
            sb.append(' ');
        }
        this.rawShape = sb.toString();
        return this;
    }

    public GUIInventory shapeDefault() {
        StringBuilder sb = new StringBuilder();
        char c = 'A';
        while (c < this.inv.getSize() + 65) {
            sb.append(c);
            c = (char)(c + '\u0001');
        }
        this.rawShape = sb.toString();
        return this;
    }

    public String getRawShape() {
        return this.rawShape;
    }

    public GUIInventory lockSlots() {
        this.isLocked = !this.isLocked;
        return this;
    }

    public boolean isSlotsLocked() {
        return this.isLocked;
    }

    public GUIInventory setItem(Object slot, ItemStack item) {
        return this.setItem(slot, item, nullConsumer);
    }

    public GUIInventory setItem(Object slot, ItemStack item, Consumer<InventoryClickEvent> con) {
        char ch = this.convert(slot);
        if (ch == '\u0000') {
            return this;
        }
        if (ch == '+' && this.rawShape.contains("+")) {
            char ch2 = 'A';
            while (this.rawShape.indexOf(ch2) >= 0) {
                ch2 = (char)(ch2 + 1);
            }
            this.rawShape = this.rawShape.replaceFirst("\\+", "" + ch2);
            ch = ch2;
        }
        this.slots.put(Character.valueOf(ch), con);
        this.setItem(ch, item);
        return this;
    }

    public GUIInventory changeProperties(String newName, int newSize, String newRawShape, int shapeMode) {
        ItemStack[] copy = this.inv.getContents();
        if (newRawShape != null) {
            if (shapeMode < 2) {
                ItemStack[] newItems = (ItemStack[])copy.clone();
                int length = this.inv.getType() == InventoryType.CHEST ? 9 * newSize : newItems.length;
                copy = new ItemStack[length];
                int x = 0;
                HashMap<Character, ItemStack> items = new HashMap<Character, ItemStack>();
                char[] cArray = this.rawShape.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char ch1 = cArray[n2];
                    if (x < newItems.length) {
                        items.put(Character.valueOf(ch1), newItems[x++]);
                    }
                    ++n2;
                }
                x = 0;
                cArray = newRawShape.toCharArray();
                n = cArray.length;
                n2 = 0;
                while (n2 < n) {
                    char ch = cArray[n2];
                    ItemStack item = (ItemStack)items.get(Character.valueOf(ch));
                    if (item != null && x < copy.length) {
                        copy[x] = item;
                    }
                    ++x;
                    ++n2;
                }
            }
            if (shapeMode % 2 == 0) {
                this.rawShape = newRawShape;
            }
        }
        if (newName != null && newSize >= 0) {
            ArrayList viewers = new ArrayList(this.inv.getViewers());
            if (newSize == 0) {
                newSize = this.inv.getSize() / 9;
            }
            this.inv = InventoryUtils.newInventory(this.inv.getType(), newSize, newName);
            if (this.inv == null) {
                return this;
            }
            this.getListener().setInventory(this.inv);
            this.inv.setContents(copy);
            viewers.forEach(human -> {
                ItemStack cursor = human.getItemOnCursor();
                human.setItemOnCursor(null);
                human.openInventory(this.inv);
                human.setItemOnCursor(cursor);
            });
        } else {
            this.inv.setContents(copy);
        }
        return this;
    }

    private void setItem(char ch, ItemStack item) {
        if (this.listener == null && (this.inv.getHolder() == null || this.inv.getViewers().size() == 0)) {
            this.items.put(Character.valueOf(ch), item);
            return;
        }
        int x = -1;
        char[] cArray = this.rawShape.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch1 = cArray[n2];
            if (++x < this.inv.getSize() && ch1 == ch) {
                this.inv.setItem(x, item);
            }
            ++n2;
        }
    }

    public Consumer<InventoryClickEvent> getSlot(int slot) {
        return slot >= 0 ? this.getSlot(this.convertSlot(slot)) : null;
    }

    public Consumer<InventoryClickEvent> getSlot(char ch) {
        if (ch > '\u0000') {
            return this.slots.get(Character.valueOf(ch));
        }
        return null;
    }

    public GUIInventory clearSlots(Object ... chars) {
        if (chars == null || chars.length == 0) {
            this.clear();
        } else {
            Object[] objectArray = chars;
            int n = chars.length;
            int n2 = 0;
            while (n2 < n) {
                Object ch = objectArray[n2];
                char ch1 = this.convert(ch);
                int x = -1;
                char[] cArray = this.rawShape.toCharArray();
                int n3 = cArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    char ch2 = cArray[n4];
                    if (++x < this.inv.getSize() && ch1 == ch2) {
                        this.setItem(ch, new ItemStack(Material.AIR));
                    }
                    ++n4;
                }
                this.slots.remove(Character.valueOf(ch1));
                ++n2;
            }
        }
        return this;
    }

    public GUIInventory clear() {
        int x = -1;
        char[] cArray = this.rawShape.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (++x < this.inv.getSize() && this.slots.containsKey(Character.valueOf(ch))) {
                this.setItem(ch, new ItemStack(Material.AIR));
            }
            ++n2;
        }
        this.slots.clear();
        return this;
    }

    public GUIInventory onClose(Consumer<InventoryCloseEvent> run) {
        this.onClose = run;
        return this;
    }

    public Consumer<InventoryCloseEvent> getOnClose() {
        return this.onClose;
    }

    public boolean hasOnClose() {
        return this.onClose != null;
    }

    public Inventory getInventory() {
        if (!this.getListener().isStarted()) {
            this.getListener().start();
            if (this.items.size() > 0) {
                int x = 0;
                char[] cArray = this.rawShape.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char ch = cArray[n2];
                    ItemStack item = this.items.get(Character.valueOf(ch));
                    if (item != null && item.getType() != Material.AIR) {
                        this.inv.setItem(x, item);
                    }
                    ++x;
                    ++n2;
                }
                this.items.clear();
            }
        }
        return this.inv;
    }

    public GUIListener getListener() {
        if (this.listener == null) {
            this.listener = new GUIListener(this.inv){

                @Override
                public void onClick(InventoryClickEvent e, int slot) {
                    Consumer<InventoryClickEvent> run = GUIInventory.this.getSlot(slot);
                    e.setCancelled(run != null || GUIInventory.this.isSlotsLocked());
                    if (run != null && slot == e.getSlot() && GUIInventory.this.inv.equals(InventoryUtils.getClickedInventory(e))) {
                        run.accept(e);
                    }
                }

                @Override
                public void onClose(InventoryCloseEvent e) {
                    block3: {
                        if (GUIInventory.this.hasOnClose()) {
                            GUIHandler.getInstance().setGUIEvent((Event)e, GUIInventory.this);
                            try {
                                GUIInventory.this.getOnClose().accept(e);
                            }
                            catch (Exception ex) {
                                if (!TuSKe.debug()) break block3;
                                Skript.exception((Throwable)ex, (String[])new String[]{"A error occurred while closing a Gui"});
                            }
                        }
                    }
                }

                @Override
                public void onDrag(InventoryDragEvent e, int slot) {
                    if (GUIInventory.this.getSlot(slot) != null) {
                        e.setCancelled(true);
                    }
                }
            };
        }
        return this.listener;
    }

    public char convertSlot(int slot) {
        if (slot < this.rawShape.length()) {
            return this.rawShape.charAt(slot);
        }
        return ' ';
    }

    public char convertSlot(String rawShape, int slot) {
        if (slot < rawShape.length()) {
            return rawShape.charAt(slot);
        }
        return ' ';
    }

    public char nextInvertedSlot() {
        char[] cArray = this.rawShape.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch2 = cArray[n2];
            if (this.slots.containsKey(Character.valueOf(ch2))) {
                return ch2;
            }
            ++n2;
        }
        return '\u0000';
    }

    public char nextSlot() {
        char[] cArray = this.rawShape.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch2 = cArray[n2];
            if (!this.slots.containsKey(Character.valueOf(ch2))) {
                return ch2;
            }
            ++n2;
        }
        return '\u0000';
    }

    private char convert(Object slot) {
        char ch = slot instanceof Number ? this.convertSlot(((Number)slot).intValue()) : (slot instanceof String && !((String)slot).isEmpty() ? ((String)slot).charAt(0) : (slot instanceof Character ? ((Character)slot).charValue() : this.nextSlot()));
        return ch;
    }
}

