/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.github.tukenuke.tuske.util.Collect;
import com.github.tukenuke.tuske.util.Registry;
import java.math.BigInteger;
import org.bukkit.event.Event;

public class ExprComplicatedMath
extends SimpleExpression<Number> {
    private Expression<Number> arg;
    private int math;

    static {
        Registry.newSimple(ExprComplicatedMath.class, "sin[e] %number%", "cos[ine] %number%", "tan[gent] %number%", "arc sin[e] %number%", "arc cos[ine] %number%", "arc tan[gent] %number%", "hyperbolic sin[e] %number%", "hyperbolic cos[ine] %number%", "hyperbolic tan[gent] %number%", "[natural ]log[arithm] %number%", "base(-| )10 log[arithm] %number%", "signum %number%", "(sqrt|square root)[ of] %number%", "(%number% factorial|%number%!)");
    }

    protected Number[] get(Event event) {
        Number n = (Number)this.arg.getSingle(event);
        if (n == null) {
            return null;
        }
        double endResult = 0.0;
        switch (this.math) {
            case 0: {
                endResult = StrictMath.sin(n.doubleValue());
                break;
            }
            case 1: {
                endResult = StrictMath.cos(n.doubleValue());
                break;
            }
            case 2: {
                endResult = StrictMath.tan(n.doubleValue());
                break;
            }
            case 3: {
                endResult = StrictMath.asin(n.doubleValue());
                break;
            }
            case 4: {
                endResult = StrictMath.acos(n.doubleValue());
                break;
            }
            case 5: {
                endResult = StrictMath.atan(n.doubleValue());
                break;
            }
            case 6: {
                endResult = StrictMath.sinh(n.doubleValue());
                break;
            }
            case 7: {
                endResult = StrictMath.cosh(n.doubleValue());
                break;
            }
            case 8: {
                endResult = StrictMath.tanh(n.doubleValue());
                break;
            }
            case 9: {
                endResult = StrictMath.log(n.doubleValue());
                break;
            }
            case 10: {
                endResult = StrictMath.log10(n.doubleValue());
                break;
            }
            case 11: {
                endResult = StrictMath.signum(n.doubleValue());
                break;
            }
            case 12: {
                endResult = StrictMath.sqrt(n.doubleValue());
                break;
            }
            case 13: {
                endResult = ExprComplicatedMath.factorial(n.intValue()).doubleValue();
            }
        }
        return Collect.asArray(endResult);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return "mathing";
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.arg = expressions[0];
        this.math = i;
        return true;
    }

    private static BigInteger factorial(int num) {
        BigInteger fact = BigInteger.ONE;
        int i = 1;
        while (i <= num) {
            fact = fact.multiply(BigInteger.valueOf(i));
            ++i;
        }
        return fact;
    }
}

