/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.metrics.MetricsTrackerFactory;
import com.zaxxer.hikari.pool.HikariPool;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSource
extends HikariConfig
implements DataSource,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final HikariPool fastPathPool;
    private volatile HikariPool pool;

    public HikariDataSource() {
        this.fastPathPool = null;
    }

    public HikariDataSource(HikariConfig configuration) {
        configuration.validate();
        configuration.copyState(this);
        LOGGER.info("{} - is starting.", (Object)configuration.getPoolName());
        this.pool = this.fastPathPool = new HikariPool(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        HikariPool result = this.pool;
        if (result == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                result = this.pool;
                if (result == null) {
                    this.validate();
                    LOGGER.info("{} - is starting.", (Object)this.getPoolName());
                    this.pool = result = new HikariPool(this);
                }
            }
        }
        return result.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pool != null ? this.pool.getUnwrappedDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.pool != null) {
            this.pool.getUnwrappedDataSource().setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        if (this.pool != null) {
            this.pool.getUnwrappedDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.pool != null ? this.pool.getUnwrappedDataSource().getLoginTimeout() : 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        if (this.pool != null) {
            if (iface.isInstance(this.pool.getUnwrappedDataSource())) {
                return (T)this.pool.getUnwrappedDataSource();
            }
            if (this.pool.getUnwrappedDataSource() != null) {
                return this.pool.getUnwrappedDataSource().unwrap(iface);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return true;
        }
        if (this.pool != null) {
            if (iface.isInstance(this.pool.getUnwrappedDataSource())) {
                return true;
            }
            if (this.pool.getUnwrappedDataSource() != null) {
                return this.pool.getUnwrappedDataSource().isWrapperFor(iface);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object metricRegistry) {
        boolean isAlreadySet = this.getMetricRegistry() != null;
        super.setMetricRegistry(metricRegistry);
        if (this.pool != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            this.pool.setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        boolean isAlreadySet = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory(metricsTrackerFactory);
        if (this.pool != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            this.pool.setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        boolean isAlreadySet = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(healthCheckRegistry);
        if (this.pool != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            this.pool.setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public void evictConnection(Connection connection) {
        if (!this.isClosed() && this.pool != null && connection.getClass().getName().startsWith("com.zaxxer.hikari")) {
            this.pool.evictConnection(connection);
        }
    }

    public void suspendPool() {
        if (!this.isClosed() && this.pool != null) {
            this.pool.suspendPool();
        }
    }

    public void resumePool() {
        if (!this.isClosed() && this.pool != null) {
            this.pool.resumePool();
        }
    }

    @Override
    public void close() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        if (this.pool != null) {
            try {
                this.pool.shutdown();
            }
            catch (InterruptedException e) {
                LOGGER.warn("Interrupted during closing", e);
            }
        }
    }

    public boolean isClosed() {
        return this.isShutdown.get();
    }

    @Deprecated
    public void shutdown() {
        LOGGER.warn("The shutdown() method has been deprecated, please use the close() method instead");
        this.close();
    }

    public String toString() {
        return "HikariDataSource (" + this.pool + ")";
    }
}

