/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.util;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.util.EnumUtils;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import java.util.StringJoiner;
import javax.annotation.Nullable;

public class EnumType
extends ClassInfo {
    public <T extends Enum<T>> EnumType(Class<T> c, String code, String regexUser) {
        this(c, code, regexUser, null);
    }

    public <T extends Enum<T>> EnumType(Class<T> c, String code, String regexUser, String languageNode) {
        super(c, code);
        String names;
        EnumUtils enumUtils = languageNode != null ? new EnumUtils(c, languageNode) : null;
        String string = names = enumUtils != null ? enumUtils.getAllNames() : null;
        if (names != null && !names.isEmpty()) {
            this.usage(new String[]{enumUtils.getAllNames()});
        } else {
            this.usage(new String[]{EnumType.getAllNames(c)});
        }
        Parser<T> parser = EnumType.getParser(c, enumUtils);
        try {
            Classes.registerClass((ClassInfo)this.user(new String[]{regexUser}).defaultExpression((DefaultExpression)new EventValueExpression(c)).parser(parser));
        }
        catch (Exception e) {
            if (!TuSKe.getInstance().getConfig().isSet("cancel_override_type." + code) && enumUtils != null) {
                ClassInfo ci = Classes.getExactClassInfo(c);
                if (ci.getParser() != null && !ci.getParser().getClass().getPackage().getName().startsWith(Skript.class.getPackage().getName())) {
                    ReflectionUtils.setField(ClassInfo.class, ci, "parser", parser);
                }
            }
            TuSKe.debug("Couldn't register the type '" + code + "'. Due to: " + (e.getMessage() != null && !e.getMessage().isEmpty() ? e.getMessage() : "unknown"));
        }
    }

    public static <T extends Enum<T>> Parser<T> getParser(final Class<T> c, final EnumUtils<T> enumUtils) {
        if (!TuSKe.getInstance().getConfig().getBoolean("use_only_enum_names")) {
            return new Parser<T>(){

                @Nullable
                public T parse(String name, ParseContext arg1) {
                    Enum result;
                    if ((name = name.replaceAll("_", " ")).startsWith(String.valueOf(c.getSimpleName().toUpperCase()) + ".")) {
                        name = name.split("\\.")[1];
                    }
                    Enum enum_ = result = enumUtils != null ? enumUtils.parse(name) : null;
                    if (result != null) {
                        return result;
                    }
                    if (enumUtils != null) {
                        return null;
                    }
                    try {
                        return Enum.valueOf(c, EnumType.fromString(name));
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public String toString(T e, int arg1) {
                    return EnumType.toString(e);
                }

                public String toVariableNameString(T e) {
                    return String.valueOf(c.getSimpleName()) + "." + ((Enum)e).name();
                }

                public String getVariableNamePattern() {
                    return "(" + c.getSimpleName().toLowerCase() + "\\.)?.+";
                }
            };
        }
        return new Parser<T>(){

            @Nullable
            public T parse(String name, ParseContext arg1) {
                if ((name = name.replaceAll("_", " ")).startsWith(String.valueOf(c.getSimpleName().toUpperCase()) + ".")) {
                    Enum result;
                    name = name.split("\\.")[1];
                    Enum enum_ = result = enumUtils != null ? enumUtils.parse(name) : null;
                    if (result != null) {
                        return result;
                    }
                    try {
                        return Enum.valueOf(c, EnumType.fromString(name));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }

            public String toString(T e, int arg1) {
                return String.valueOf(((Enum)e).getDeclaringClass().getSimpleName()) + "." + EnumType.toString(e);
            }

            public String toVariableNameString(T e) {
                return String.valueOf(c.getSimpleName()) + "." + ((Enum)e).name();
            }

            public String getVariableNamePattern() {
                return "(" + c.getSimpleName().toLowerCase() + "\\.)?.+";
            }
        };
    }

    public static String getAllNames(Class<? extends Enum> enumClz) {
        StringJoiner sj = new StringJoiner(", ");
        Enum[] enumArray = enumClz.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            sj.add(EnumType.toString(e));
            ++n2;
        }
        return sj.toString();
    }

    public static String toString(Enum<?> e) {
        return e.name().toLowerCase().replaceAll("_", " ");
    }

    public static String fromString(String str) {
        return str.toUpperCase().replaceAll("\\s+", "_");
    }
}

