/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.lang.ExpressionType;
import com.github.tukenuke.tuske.expressions.ExprItemNBT;
import com.github.tukenuke.tuske.expressions.ExprNBTOf;
import com.github.tukenuke.tuske.manager.gui.GUIManager;
import com.github.tukenuke.tuske.manager.gui.v2.SkriptGUIEvent;
import com.github.tukenuke.tuske.util.ReflectionUtils;
import com.github.tukenuke.tuske.util.Registry;
import com.github.tukenuke.tuske.util.Title;
import com.github.tukenuke.tuske.util.nbt.NMSInterface;
import com.github.tukenuke.tuske.util.nbt.NMS_v1_10_R1;
import com.github.tukenuke.tuske.util.nbt.NMS_v1_11_R1;
import com.github.tukenuke.tuske.util.nbt.NMS_v1_12_R1;
import com.github.tukenuke.tuske.util.nbt.NMS_v1_8_R3;
import com.github.tukenuke.tuske.util.nbt.NMS_v1_9_R1;
import com.github.tukenuke.tuske.util.nbt.NMS_v1_9_R2;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TuSKe
extends JavaPlugin {
    private static TuSKe plugin;
    private static GUIManager gui;
    private Title title;
    private static NMSInterface nmsMethods;

    public TuSKe() {
        if (plugin != null) {
            throw new IllegalStateException("TuSKe can't have two instances.");
        }
        plugin = this;
    }

    public void onEnable() {
        Boolean hasSkript = this.hasPlugin("Skript");
        if (!hasSkript.booleanValue() || !Skript.isAcceptRegistrations()) {
            if (!hasSkript.booleanValue()) {
                TuSKe.log("Error 404 - Skript not found.", Level.SEVERE);
            } else {
                TuSKe.log("TuSKe can't be loaded when the server is already loaded.", Level.SEVERE);
            }
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.setupNMSVersion()) {
            Registry.newSimple(ExprItemNBT.class, "%itemstack% with [custom] nbt[[ ]tag[s]] %string%");
            Skript.registerExpression(ExprNBTOf.class, Object.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"nbt[[ ]tag[s]] of %~object%", "%~object%'s nbt[[ ]tag[s]]"});
        }
        SkriptAddon tuske = Skript.registerAddon((JavaPlugin)this).setLanguageFileDirectory("lang");
        try {
            this.title = new Title();
            this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            tuske.loadClasses(((Object)((Object)this)).getClass().getPackage().getName(), new String[]{"register", "conditions", "effects", "sections", "expressions"});
        }
        catch (Exception e) {
            this.info("Error while registering stuff", new Object[0]);
            e.printStackTrace();
        }
    }

    public void onDisable() {
        SkriptGUIEvent.getInstance().unregisterAll();
        if (gui != null) {
            gui.clearAll();
        }
        HandlerList.unregisterAll((Plugin)this);
        Bukkit.getScheduler().cancelTasks((Plugin)this);
    }

    public static TuSKe getInstance() {
        return plugin;
    }

    public boolean hasPlugin(String str) {
        return plugin.getServer().getPluginManager().isPluginEnabled(str);
    }

    public void info(String msg, Object ... values) {
        TuSKe.log(String.format(msg, values), Level.INFO);
    }

    public static GUIManager getGUIManager() {
        if (gui == null) {
            gui = new GUIManager(TuSKe.getInstance());
        }
        return gui;
    }

    public static void log(String msg) {
        TuSKe.log(msg, Level.INFO);
    }

    public static void log(String msg, Level lvl) {
        plugin.getLogger().log(lvl, msg);
    }

    public static void log(Level lvl, String ... msgs) {
        String[] stringArray = msgs;
        int n = msgs.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            TuSKe.log(msg, lvl);
            ++n2;
        }
    }

    public static boolean debug() {
        return plugin.getConfig().getBoolean("debug_mode");
    }

    public static void debug(Object ... objects) {
        if (!TuSKe.debug()) {
            return;
        }
        StackTraceElement caller = new Exception().getStackTrace()[1];
        TuSKe.log(String.format("[Debug] [%s, line %s] %s", caller.getFileName(), caller.getLineNumber(), StringUtils.join((Object[])objects, (String)" || ")));
    }

    public static boolean isSpigot() {
        return ReflectionUtils.hasMethod(Player.class, "spigot", new Class[0]);
    }

    private boolean setupNMSVersion() {
        String version = ReflectionUtils.getVersion();
        if (version.equals("v1_8_R3.")) {
            nmsMethods = new NMS_v1_8_R3();
        } else if (version.equals("v1_9_R1.")) {
            nmsMethods = new NMS_v1_9_R1();
        } else if (version.equals("v1_9_R2.")) {
            nmsMethods = new NMS_v1_9_R2();
        } else if (version.equals("v1_10_R1.")) {
            nmsMethods = new NMS_v1_10_R1();
        } else if (version.equals("v1_11_R1.")) {
            nmsMethods = new NMS_v1_11_R1();
        } else if (version.equals("v1_12_R1.")) {
            nmsMethods = new NMS_v1_12_R1();
        }
        return nmsMethods != null;
    }

    public static NMSInterface getNMSMethods() {
        return nmsMethods;
    }

    public Title getTitle() {
        return this.title;
    }
}

