/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.skript.util.Slot;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.github.tukenuke.tuske.TuSKe;
import com.github.tukenuke.tuske.util.nbt.ReflectionUtils;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ExprNBTOf
extends SimpleExpression<Object> {
    private Expression<Object> target;
    private Class<?> nbtClass = ReflectionUtils.getNMSClass("NBTTagCompound");

    public Class<? extends Object> getReturnType() {
        return this.nbtClass;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult result) {
        this.target = expr[0];
        Class type = this.target.getReturnType();
        if (type != Entity.class || type != Block.class || type != ItemStack.class || type != Slot.class) {
            Skript.error((String)(String.valueOf(this.target.toString()) + " is neither an entity, a block nor an itemstack."), (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
        }
        return true;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "the NBT of " + this.target.toString(e, debug);
    }

    @Nullable
    public Object[] get(Event e) {
        Object tar = this.target.getSingle(e);
        if (tar instanceof Entity) {
            return new Object[]{TuSKe.getNMSMethods().getEntityNBT((Entity)tar)};
        }
        if (tar instanceof Block) {
            return new Object[]{TuSKe.getNMSMethods().getTileNBT((Block)tar)};
        }
        if (tar instanceof ItemStack) {
            return new Object[]{TuSKe.getNMSMethods().getItemNBT((ItemStack)tar)};
        }
        if (tar instanceof Slot) {
            return new Object[]{TuSKe.getNMSMethods().getItemNBT(((Slot)tar).getItem())};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object tar = this.target.getSingle(e);
        Object parsedNBT = null;
        if (delta != null) {
            parsedNBT = TuSKe.getNMSMethods().parseRawNBT((String)delta[0]);
        }
        if (tar instanceof Entity) {
            Object entNBT = TuSKe.getNMSMethods().getEntityNBT((Entity)tar);
            if (mode == Changer.ChangeMode.ADD) {
                TuSKe.getNMSMethods().removeFromCompound(parsedNBT, "UUIDMost", "UUIDLeast", "WorldUUDMost", "WorldUUIDLeast", "Bukkit.updateLevel");
                TuSKe.getNMSMethods().addToCompound(entNBT, parsedNBT);
                TuSKe.getNMSMethods().setEntityNBT((Entity)tar, entNBT);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                Object[] objectArray = delta;
                int n = delta.length;
                int n2 = 0;
                while (n2 < n) {
                    Object s = objectArray[n2];
                    if (s != "UUIDMost" || s != "UUIDLeast" || s != "WorldUUIDMost" || s != "WorldUUIDLeast" || s != "Bukkit.updateLevel") {
                        TuSKe.getNMSMethods().removeFromCompound(entNBT, (String)s);
                    }
                    ++n2;
                }
                TuSKe.getNMSMethods().setEntityNBT((Entity)tar, entNBT);
            }
        } else if (tar instanceof Block) {
            Object blockNBT = TuSKe.getNMSMethods().getTileNBT((Block)tar);
            if (mode == Changer.ChangeMode.ADD) {
                TuSKe.getNMSMethods().removeFromCompound(parsedNBT, "x", "y", "z", "id");
                TuSKe.getNMSMethods().addToCompound(blockNBT, parsedNBT);
                TuSKe.getNMSMethods().setTileNBT((Block)tar, blockNBT);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                Object[] objectArray = delta;
                int n = delta.length;
                int n3 = 0;
                while (n3 < n) {
                    Object s = objectArray[n3];
                    if (s != "x" || s != "y" || s != "z" || s != "id") {
                        TuSKe.getNMSMethods().removeFromCompound(blockNBT, (String)s);
                    }
                    ++n3;
                }
                TuSKe.getNMSMethods().setTileNBT((Block)tar, blockNBT);
            }
        } else if (tar instanceof ItemStack) {
            if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                Skript.warning((String)"Failed to change the NBT of an item: Itemstack didn't have any slot attached to it.");
            }
        } else if (tar instanceof Slot) {
            ItemStack slotItem = ((Slot)tar).getItem();
            Object itemNBT = TuSKe.getNMSMethods().getItemNBT(slotItem);
            if (mode == Changer.ChangeMode.ADD) {
                TuSKe.getNMSMethods().addToCompound(itemNBT, parsedNBT);
                ItemStack newItem = TuSKe.getNMSMethods().getItemWithNBT(slotItem, itemNBT);
                ((Slot)tar).setItem(newItem);
            } else if (mode == Changer.ChangeMode.REMOVE) {
                String[] toRemove = (String[])Arrays.copyOf(delta, delta.length, String[].class);
                TuSKe.getNMSMethods().removeFromCompound(itemNBT, toRemove);
                ItemStack newItem = TuSKe.getNMSMethods().getItemWithNBT(slotItem, itemNBT);
                ((Slot)tar).setItem(newItem);
            } else if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
                ItemStack newItem = TuSKe.getNMSMethods().getItemWithNBT(slotItem, null);
                ((Slot)tar).setItem(newItem);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{String[].class});
        }
        return null;
    }
}

