/*
 * Decompiled with CFR 0.152.
 */
package com.github.tukenuke.tuske.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import com.github.tukenuke.tuske.util.Registry;
import javax.annotation.Nullable;
import org.bukkit.inventory.ItemStack;

@Name(value="Max Durability")
@Description(value={"Returns the max durability of {{types|ItemStack|item stack}}. i.e. 1561 for diamond sword. You can cancel it."})
@Examples(value={"on item damage:", "\tif durability of event-item is more than (max durability of event-item - item damage):", "\t\tsend \"Your %event-item% is almost breaking!\""})
@Since(value="1.1")
public class ExprMaxDurability
extends SimplePropertyExpression<ItemStack, Integer> {
    static {
        Registry.newProperty(ExprMaxDurability.class, "max durability", "itemstack");
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @Nullable
    public Integer convert(ItemStack i) {
        return i != null ? Integer.valueOf(i.getType().getMaxDurability()) : null;
    }

    protected String getPropertyName() {
        return "max durability";
    }
}

