/*
 * Decompiled with CFR 0.152.
 */
package pl.pickaxe.largesk.util;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SignGUI {
    protected ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
    protected PacketAdapter packetListener;
    protected Map<String, SignGUIListener> listeners = new ConcurrentHashMap<String, SignGUIListener>();
    protected Map<String, Vector> signLocations = new ConcurrentHashMap<String, Vector>();

    public SignGUI(Plugin plugin) {
        this.packetListener = new PacketAdapter(plugin, new PacketType[]{PacketType.Play.Client.UPDATE_SIGN}){

            public void onPacketReceiving(PacketEvent event) {
                final Player player = event.getPlayer();
                Vector v = SignGUI.this.signLocations.remove(player.getName());
                BlockPosition bp = (BlockPosition)event.getPacket().getBlockPositionModifier().getValues().get(0);
                WrappedChatComponent[] chatarray = (WrappedChatComponent[])event.getPacket().getChatComponentArrays().getValues().get(0);
                final String[] lines = new String[]{chatarray[0].getJson(), chatarray[1].getJson(), chatarray[2].getJson(), chatarray[3].getJson()};
                final SignGUIListener response = SignGUI.this.listeners.remove(event.getPlayer().getName());
                if (v == null) {
                    return;
                }
                if (bp.getX() != v.getBlockX()) {
                    return;
                }
                if (bp.getY() != v.getBlockY()) {
                    return;
                }
                if (bp.getZ() != v.getBlockZ()) {
                    return;
                }
                if (response != null) {
                    event.setCancelled(true);
                    Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            response.onSignDone(player, lines);
                        }
                    });
                }
            }
        };
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.packetListener);
    }

    public void open(Player player, String[] defaultText, SignGUIListener response) {
        Object packet53;
        ArrayList<Object> packets = new ArrayList<Object>();
        int x = player.getLocation().getBlockX();
        int y = 0;
        int z = player.getLocation().getBlockZ();
        BlockPosition bpos = new BlockPosition(x, y, z);
        PacketContainer packet133 = this.protocolManager.createPacket(PacketType.Play.Server.OPEN_SIGN_ENTITY);
        if (defaultText != null) {
            packet53 = this.protocolManager.createPacket(PacketType.Play.Server.BLOCK_CHANGE);
            PacketContainer packetContainer = this.protocolManager.createPacket(PacketType.Play.Server.UPDATE_SIGN);
            WrappedBlockData iblock = WrappedBlockData.createData((Material)Material.SIGN_POST);
            WrappedChatComponent[] cc = new WrappedChatComponent[]{WrappedChatComponent.fromText((String)defaultText[0]), WrappedChatComponent.fromText((String)defaultText[1]), WrappedChatComponent.fromText((String)defaultText[2]), WrappedChatComponent.fromText((String)defaultText[3])};
            packet53.getBlockPositionModifier().write(0, (Object)bpos);
            packet53.getBlockData().write(0, (Object)iblock);
            packetContainer.getBlockPositionModifier().write(0, (Object)bpos);
            packetContainer.getChatComponentArrays().write(0, (Object)cc);
            packets.add(packet53);
            packets.add(packetContainer);
        }
        packet133.getBlockPositionModifier().write(0, (Object)bpos);
        packets.add(packet133);
        if (defaultText != null) {
            packet53 = this.protocolManager.createPacket(PacketType.Play.Server.BLOCK_CHANGE);
            WrappedBlockData wrappedBlockData = WrappedBlockData.createData((Material)Material.BEDROCK);
            packet53.getBlockPositionModifier().write(0, (Object)bpos);
            packet53.getBlockData().write(0, (Object)wrappedBlockData);
            packets.add(packet53);
        }
        try {
            for (PacketContainer packetContainer : packets) {
                this.protocolManager.sendServerPacket(player, packetContainer);
            }
            this.signLocations.put(player.getName(), new Vector(x, y, z));
            this.listeners.put(player.getName(), response);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
        this.protocolManager.removePacketListener((PacketListener)this.packetListener);
        this.listeners.clear();
        this.signLocations.clear();
    }

    public static interface SignGUIListener {
        public void onSignDone(Player var1, String[] var2);
    }
}

