/*
 * Decompiled with CFR 0.152.
 */
package pl.pickaxe.largesk.networkcoins;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import com.google.common.primitives.Ints;
import javax.annotation.Nullable;
import me.josh.networkcoins.API;
import org.bukkit.OfflinePlayer;
import org.bukkit.event.Event;

public class ExprNetworkCoins
extends SimpleExpression<Integer> {
    private Expression<OfflinePlayer> pl;

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.pl = expr[0];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "network coins of " + this.pl.toString();
    }

    protected Integer[] get(Event e) {
        return new Integer[]{API.getCoinsOffline((OfflinePlayer)((OfflinePlayer)this.pl.getSingle(e)))};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Integer wanted;
        OfflinePlayer o = (OfflinePlayer)this.pl.getSingle(e);
        if (o == null) {
            return;
        }
        if (!API.isInDb((OfflinePlayer)o)) {
            return;
        }
        if (mode == Changer.ChangeMode.SET) {
            wanted = Ints.checkedCast((long)((Long)delta[0]));
            Integer before = API.getCoinsOffline((OfflinePlayer)o);
            if (wanted == null || before == null || before == wanted) {
                return;
            }
            if (before < wanted) {
                API.addCoinsOffline((OfflinePlayer)o, (Integer)(wanted - before));
            } else if (before > wanted) {
                API.takeCoinsOffline((OfflinePlayer)o, (Integer)(before - wanted));
            }
        }
        if (mode == Changer.ChangeMode.ADD) {
            wanted = Ints.checkedCast((long)((Long)delta[0]));
            API.addCoinsOffline((OfflinePlayer)o, (Integer)wanted);
        }
        if (mode == Changer.ChangeMode.REMOVE) {
            wanted = Ints.checkedCast((long)((Long)delta[0]));
            API.takeCoinsOffline((OfflinePlayer)o, (Integer)wanted);
        }
        if (mode == Changer.ChangeMode.RESET) {
            API.resetCoinsOffline((OfflinePlayer)((OfflinePlayer)this.pl.getSingle(e)));
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
        }
        return null;
    }

    public static void register() {
        Skript.registerExpression(ExprNetworkCoins.class, Integer.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"network coin[s] of %offlineplayer%", "%offlineplayer%'s network coins"});
    }
}

