/*
 * Decompiled with CFR 0.152.
 */
package pl.pickaxe.largesk.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import javax.annotation.Nullable;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprFullTime
extends SimpleExpression<Long> {
    private Expression<World> world;

    public Class<? extends Long> getReturnType() {
        return Long.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int arg1, Kleenean arg2, SkriptParser.ParseResult arg3) {
        this.world = expr[0];
        return true;
    }

    public String toString(@Nullable Event arg0, boolean arg1) {
        return "full time of world";
    }

    @Nullable
    protected Long[] get(Event e) {
        return new Long[]{((World)this.world.getSingle(e)).getFullTime()};
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            ((World)this.world.getSingle(e)).setFullTime(((Long)delta[0]).longValue());
        } else if (mode == Changer.ChangeMode.ADD) {
            ((World)this.world.getSingle(e)).setFullTime(((World)this.world.getSingle(e)).getFullTime() + (Long)delta[0]);
        } else if (mode == Changer.ChangeMode.RESET) {
            ((World)this.world.getSingle(e)).setFullTime(0L);
        } else if (mode == Changer.ChangeMode.REMOVE) {
            if (((World)this.world.getSingle(e)).getFullTime() > (Long)delta[0]) {
                ((World)this.world.getSingle(e)).setFullTime(((World)this.world.getSingle(e)).getFullTime() - (Long)delta[0]);
            } else {
                ((World)this.world.getSingle(e)).setFullTime(0L);
            }
        }
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.REMOVE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Long.class});
        }
        return null;
    }

    public static void register() {
        Skript.registerExpression(ExprFullTime.class, Long.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"(full|total)[ ]time of %world%", "%world%'s (full|total)[ ]time"});
    }
}

