/*
 * Decompiled with CFR 0.152.
 */
package an0nym8us.api.messaging.server;

import an0nym8us.api.events.EventManager;
import an0nym8us.api.messaging.HandshakePacket;
import an0nym8us.api.messaging.Listener;
import an0nym8us.api.messaging.Packet;
import an0nym8us.api.messaging.PacketStruct;
import an0nym8us.api.messaging.server.Server;
import an0nym8us.api.messaging.server.events.DuplicatedServerConnectionTrialEvent;
import an0nym8us.api.messaging.server.events.ServerConnectedEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;

public class ProxyListener
extends Listener {
    static final String SERVER_ALL = "ALL";
    static final String SERVER_PROXY = "BUNGEE";
    public static final int PORT = 30001;
    protected static ProxyListener instance;
    ServerSocket serverSocket;
    List<Server> servers;
    int proxyPort;

    public ProxyListener() throws IllegalAccessException {
        this(30001);
    }

    public ProxyListener(int proxyPort) throws IllegalAccessException {
        super(SERVER_PROXY);
        this.serverName = SERVER_PROXY;
        this.proxyPort = proxyPort;
        if (instance != null) {
            throw new IllegalAccessException("ProxyListener has already created instance!");
        }
        instance = this;
        this.servers = new ArrayList<Server>();
        this.scheduleTask();
    }

    public static ProxyListener GetInstance() {
        return instance;
    }

    @Override
    protected void scheduleTask() {
        this.listeningThread.start();
    }

    @Override
    protected void listeningTaskFunc() throws IOException, InterruptedException {
        try {
            this.serverSocket = new ServerSocket(this.proxyPort);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.listeningThread.interrupt();
            return;
        }
        while (true) {
            try {
                while (true) {
                    Socket socket = this.serverSocket.accept();
                    HandshakePacket handshakePacket = new HandshakePacket(socket.getInputStream());
                    if (this.GetServer(handshakePacket.serverName) != null) {
                        EventManager.callEvent(new DuplicatedServerConnectionTrialEvent(handshakePacket.serverName));
                        Packet disconnectPacket = new Packet(PacketStruct.DuplicatedConnection.packetID);
                        disconnectPacket.WritePacket(socket.getOutputStream(), handshakePacket.key, handshakePacket.IV);
                        socket.close();
                        continue;
                    }
                    this.servers.add(new Server(handshakePacket.serverName, socket, handshakePacket.key, handshakePacket.IV));
                    EventManager.callEvent(new ServerConnectedEvent(handshakePacket.serverName));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public boolean SendMessage(String channel, String destinationServer, byte[] data) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        ArrayList<String> list = new ArrayList<String>();
        while (dis.available() > 0) {
            list.add(dis.readUTF());
        }
        return this.SendMessage(channel, destinationServer, list.toArray(new String[list.size()]));
    }

    public boolean SendMessage(String channel, String destinationServer, String ... array) throws IOException {
        return ProxyListener.GetInstance().GetServer(destinationServer).SendMessage(channel, destinationServer, array);
    }

    @Override
    public void Dispose() {
        for (Server server : this.servers) {
            server.Dispose();
        }
        super.Dispose();
    }

    public Server GetServer(String serverName) {
        for (Server server : this.servers) {
            if (!server.GetName().equals(serverName)) continue;
            return server;
        }
        return null;
    }
}

