/*
 * Decompiled with CFR 0.152.
 */
package an0nym8us.api.messaging.client;

import an0nym8us.api.events.EventManager;
import an0nym8us.api.messaging.HandshakePacket;
import an0nym8us.api.messaging.Packet;
import an0nym8us.api.messaging.PacketStruct;
import an0nym8us.api.messaging.SocketListener;
import an0nym8us.api.messaging.client.events.ConnectionClosedEvent;
import an0nym8us.api.messaging.client.events.MessageReceivedEvent;
import an0nym8us.api.messaging.client.events.ProxyDisconnectedEvent;
import an0nym8us.api.messaging.client.events.ServerConnectedEvent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ServerListener
extends SocketListener {
    static ServerListener instance;
    public String proxyIP;
    public int proxyPort;

    public ServerListener(String serverName) throws IllegalAccessException {
        this(serverName, "127.0.0.1", 30001);
    }

    public ServerListener(String serverName, String proxyIP, int proxyPort) throws IllegalAccessException {
        super(serverName);
        this.proxyIP = proxyIP;
        this.proxyPort = proxyPort;
        if (instance != null) {
            throw new IllegalAccessException("ServerListener has already created instance!");
        }
        instance = this;
        this.serverName = serverName;
        this.scheduleTask();
    }

    public static ServerListener getInstance() {
        return instance;
    }

    @Override
    protected void scheduleTask() {
        this.listeningThread.start();
    }

    @Override
    protected void listeningTaskFunc() throws IOException, InterruptedException {
        try {
            if (this.socket != null && this.socket.isConnected()) {
                this.socket.close();
            }
            this.Connect();
        }
        catch (IOException ex) {
            Thread.sleep(1000L);
            return;
        }
        try {
            while (true) {
                Packet packet;
                if ((packet = new Packet(this.socket.getInputStream(), this.secretKey, this.iv)).GetPacketStruct().equals((Object)PacketStruct.Server)) {
                    EventManager.callEvent(new MessageReceivedEvent(packet.GetValue("channel"), packet.GetValue("serverFrom"), packet.GetValue("serverTo"), packet.GetParams()));
                    continue;
                }
                if (packet.GetPacketStruct().equals((Object)PacketStruct.DuplicatedConnection)) break;
            }
            EventManager.callEvent(new ConnectionClosedEvent(ConnectionClosedEvent.DisconnectReason.DuplicatedConnection));
            this.listeningThread.interrupt();
            return;
        }
        catch (SocketException ex) {
            EventManager.callEvent(new ProxyDisconnectedEvent());
            Thread.sleep(1000L);
            return;
        }
        catch (Exception ex) {
            EventManager.callEvent(new ProxyDisconnectedEvent());
            ex.printStackTrace();
            Thread.sleep(1000L);
            return;
        }
    }

    public OutputStream GetOutput() {
        try {
            return this.socket.getOutputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    void Connect() throws UnknownHostException, IOException {
        this.socket = new Socket(this.proxyIP, this.proxyPort);
        HandshakePacket packet = new HandshakePacket(this.secretKey, this.iv, this.serverName);
        packet.WritePacket(this.socket.getOutputStream());
        EventManager.callEvent(new ServerConnectedEvent());
    }

    boolean IsConnected() {
        return this.socket != null && this.socket.isConnected();
    }
}

