/*
 * Decompiled with CFR 0.152.
 */
package an0nym8us.api.messaging;

import an0nym8us.api.events.EventManager;
import an0nym8us.api.messaging.CryptoStance;
import an0nym8us.api.messaging.Listener;
import an0nym8us.api.messaging.Packet;
import an0nym8us.api.messaging.PacketStruct;
import an0nym8us.api.messaging.client.events.MessageSentEvent;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import javax.crypto.SecretKey;

public abstract class SocketListener
extends Listener {
    public Socket socket;
    public SecretKey secretKey;
    protected byte[] iv;

    public SocketListener(String serverName) {
        super(serverName);
        this.secretKey = CryptoStance.GenerateKey();
        this.iv = CryptoStance.GenerateIV();
    }

    public SocketListener(String serverName, SecretKey secretKey, byte[] iv) {
        super(serverName);
        this.secretKey = secretKey;
        this.iv = iv;
    }

    @Override
    public void Dispose() {
        super.Dispose();
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean SendMessage(String channel, String destinationServer, byte[] data) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        ArrayList<String> list = new ArrayList<String>();
        while (dis.available() > 0) {
            list.add(dis.readUTF());
        }
        return this.SendMessage(channel, destinationServer, list.toArray(new String[list.size()]));
    }

    public boolean SendMessage(String channel, String destinationServer, String ... array) throws IOException {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(array));
        list.add(0, channel);
        list.add(1, this.serverName);
        list.add(2, destinationServer);
        Packet packet = new Packet(PacketStruct.Server.packetID, list.toArray(new String[list.size()]));
        EventManager.callEvent(new MessageSentEvent(channel, this.serverName, destinationServer, packet.GetData()));
        return packet.WritePacket(this.socket.getOutputStream(), this.secretKey, this.iv);
    }
}

