/*
 * Decompiled with CFR 0.152.
 */
package an0nym8us.api.messaging;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class HandshakePacket {
    public SecretKey key;
    public byte[] IV;
    public String serverName;
    public int packetID = 0;

    public HandshakePacket(SecretKey key, byte[] IV, String serverName) {
        this.key = key;
        this.IV = IV;
        this.serverName = serverName;
    }

    public HandshakePacket(InputStream input) throws IOException {
        DataInputStream dis = new DataInputStream(input);
        int length = dis.readInt();
        byte[] data = new byte[length];
        dis.readFully(data);
        dis = new DataInputStream(new ByteArrayInputStream(data));
        int packetID = dis.readInt();
        int secretLength = dis.readInt();
        int ivLength = dis.readInt();
        byte[] key = new byte[secretLength];
        this.IV = new byte[ivLength];
        dis.read(key, 0, key.length);
        dis.read(this.IV, 0, this.IV.length);
        this.serverName = dis.readUTF();
        this.key = new SecretKeySpec(key, 0, key.length, "AES");
    }

    public boolean WritePacket(OutputStream output) {
        try {
            ByteArrayDataOutput outStream = ByteStreams.newDataOutput();
            outStream.writeInt(this.packetID);
            outStream.writeInt(this.key.getEncoded().length);
            outStream.writeInt(this.IV.length);
            outStream.write(this.key.getEncoded());
            outStream.write(this.IV);
            outStream.writeUTF(this.serverName);
            DataOutputStream dos = new DataOutputStream(output);
            dos.writeInt(outStream.toByteArray().length);
            dos.write(outStream.toByteArray());
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }
}

