/*
 * Decompiled with CFR 0.152.
 */
package an0nym8us.api.events;

import an0nym8us.api.events.EventHandler;
import an0nym8us.api.events.MessagingEvent;
import an0nym8us.api.events.MessagingListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class EventManager {
    private static volatile List<RegisteredListener> handlers = new ArrayList<RegisteredListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerListener(MessagingListener listener) {
        List<RegisteredListener> list = handlers;
        synchronized (list) {
            handlers.add(new RegisteredListener(listener));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterListener(MessagingListener listener) {
        List<RegisteredListener> list = handlers;
        synchronized (list) {
            for (int i = 0; i < handlers.size(); ++i) {
                if (!handlers.get(i).GetListener().equals(listener)) continue;
                handlers.get(i).Unregister();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAllListeners() {
        List<RegisteredListener> list = handlers;
        synchronized (list) {
            for (int i = 0; i < handlers.size(); ++i) {
                handlers.get(i).Unregister();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void callEvent(MessagingEvent event) {
        try {
            List<RegisteredListener> list = handlers;
            synchronized (list) {
                for (int i = 0; i < handlers.size(); ++i) {
                    Method[] methods;
                    if (!handlers.get(i).IsRegistered()) continue;
                    for (Method method : methods = handlers.get(i).GetListener().getClass().getDeclaredMethods()) {
                        if (!method.isAnnotationPresent(EventHandler.class) || !method.getParameterTypes()[0].equals(event.getClass())) continue;
                        method.invoke((Object)handlers.get(i).GetListener(), event);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static class RegisteredListener {
        private MessagingListener listener;
        private boolean isRegistered;

        public RegisteredListener(MessagingListener listener) {
            this.listener = listener;
            this.isRegistered = true;
        }

        public boolean IsRegistered() {
            return this.isRegistered;
        }

        public void Unregister() {
            this.isRegistered = false;
        }

        public MessagingListener GetListener() {
            return this.listener;
        }
    }
}

