/*
 * Decompiled with CFR 0.152.
 */
package pl.pickaxe.largesk.register;

import me.konsolas.aac.api.HackType;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import pl.pickaxe.largesk.LargeSk;
import pl.pickaxe.largesk.register.Bungee;
import pl.pickaxe.largesk.register.Conditions;
import pl.pickaxe.largesk.register.Effects;
import pl.pickaxe.largesk.register.Events;
import pl.pickaxe.largesk.register.Expressions;
import pl.pickaxe.largesk.util.EnumClassInfo;
import pl.pickaxe.largesk.util.LargeConfig;
import pl.pickaxe.largesk.util.Xlog;

public class Register {
    LargeConfig largeconfig = new LargeConfig();
    FileConfiguration config = this.largeconfig.getConfig();

    public void registerAll() {
        Expressions expressions = new Expressions();
        Conditions conditions = new Conditions();
        Effects effects = new Effects();
        Events events = new Events();
        Bungee bungee = new Bungee();
        expressions.registerGeneral();
        conditions.registerGeneral();
        effects.registerGeneral();
        events.registerGeneral();
        if (this.isPluginOnServer("AAC") && this.config.getConfigurationSection("enable").getBoolean("AAC")) {
            Xlog.logInfo("I have found AAC on your server. I'm pleased to announce we will work together from now.");
            EnumClassInfo.create(HackType.class, "hacktype").register();
            expressions.registerAAC();
            conditions.registerAAC();
            effects.registerAAC();
            events.registerAAC();
        }
        if (this.isPluginOnServer("SkinsRestorer") && this.config.getConfigurationSection("enable").getBoolean("SkinsRestorer")) {
            Xlog.logInfo("SkinsRestorer has been detected! Registring conditions, expressions and other boring stuff..");
            expressions.registerSkinsRestorer();
            conditions.registerSkinsRestorer();
        }
        if (this.isPluginOnServer("ProtocolLib") && LargeSk.debug) {
            Xlog.logInfo("Yeah, ProtocolLib! Let's go crazy..");
            effects.registerProtocolLib();
        }
        if (this.config.getConfigurationSection("bungee").getBoolean("use")) {
            bungee.registerAll();
        }
    }

    public boolean isPluginOnServer(String name) {
        Plugin pl = Bukkit.getServer().getPluginManager().getPlugin(name);
        return pl != null;
    }
}

