/*
 * Decompiled with CFR 0.152.
 */
package pl.pickaxe.largesk.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.message.Message;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import pl.pickaxe.largesk.util.Metrics;

public class ConsoleLogger
extends JavaPlugin {
    public void onEnable() {
        this.reloadConfig();
        this.reloadFilter();
        Bukkit.getScheduler().runTaskLater((Plugin)this, new Runnable(){

            @Override
            public void run() {
                ConsoleLogger.this.reloadConfig();
                ConsoleLogger.this.reloadFilter();
                ConsoleLogger.this.log("&3Filters now turned on.");
            }
        }, 100L);
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException e) {
            this.log("&4Failed to start Metrics: &e" + e.getMessage());
        }
        this.log(String.valueOf(this.getName()) + " v" + this.getDescription().getVersion() + " by BillyGalbreath enabled!");
    }

    public void log(Object obj) {
        if (this.getConfig().getBoolean("color-logs", true)) {
            this.getServer().getConsoleSender().sendMessage(this.colorize("&3[&d" + this.getName() + "&3]&r " + obj));
        } else {
            Bukkit.getLogger().log(java.util.logging.Level.INFO, "[" + this.getName() + "] " + ((String)obj).replaceAll("(?)\u00a7([a-f0-9k-or])", ""));
        }
    }

    public String colorize(String str) {
        return str.replaceAll("(?i)&([a-f0-9k-or])", "\u00a7$1");
    }

    public void reloadFilter() {
        Logger coreLogger = (Logger)LogManager.getRootLogger();
        Filter filter = new Filter(){

            public Filter.Result filter(LogEvent event) {
                ConfigurationSection filters = ConsoleLogger.this.getConfig().getConfigurationSection("filters");
                for (String level : filters.getKeys(false)) {
                    if (!event.getLevel().equals((Object)Level.valueOf((String)level))) continue;
                    ConfigurationSection filterLevels = filters.getConfigurationSection(level);
                    for (String filterType : filterLevels.getKeys(false)) {
                        List msgs = filterLevels.getStringList(filterType);
                        for (String msg : msgs) {
                            if (filterType.equalsIgnoreCase("equals") && event.getMessage().toString().equals(msg)) {
                                return Filter.Result.DENY;
                            }
                            if (filterType.equalsIgnoreCase("equalsignorecase") && event.getMessage().toString().equalsIgnoreCase(msg)) {
                                return Filter.Result.DENY;
                            }
                            if (filterType.equalsIgnoreCase("contains") && event.getMessage().toString().contains(msg)) {
                                return Filter.Result.DENY;
                            }
                            if (filterType.equalsIgnoreCase("endswith") && event.getMessage().toString().endsWith(msg)) {
                                return Filter.Result.DENY;
                            }
                            if (filterType.equalsIgnoreCase("startswith") && event.getMessage().toString().startsWith(msg)) {
                                return Filter.Result.DENY;
                            }
                            if (!filterType.equalsIgnoreCase("matches") || !event.getMessage().toString().matches(msg)) continue;
                            return Filter.Result.DENY;
                        }
                    }
                }
                return null;
            }

            public Filter.Result filter(Logger arg0, Level arg1, Marker arg2, String arg3, Object ... arg4) {
                return null;
            }

            public Filter.Result filter(Logger arg0, Level arg1, Marker arg2, Object arg3, Throwable arg4) {
                return null;
            }

            public Filter.Result filter(Logger arg0, Level arg1, Marker arg2, Message arg3, Throwable arg4) {
                return null;
            }

            public Filter.Result getOnMatch() {
                return null;
            }

            public Filter.Result getOnMismatch() {
                return null;
            }

            public LifeCycle.State getState() {
                return null;
            }

            public void initialize() {
            }

            public boolean isStarted() {
                return false;
            }

            public boolean isStopped() {
                return false;
            }

            public void start() {
            }

            public void stop() {
            }
        };
        boolean alreadyLoaded = false;
        Iterator iter = coreLogger.getFilters();
        while (iter.hasNext()) {
            if (!filter.equals(iter.next())) continue;
            alreadyLoaded = true;
            break;
        }
        if (!alreadyLoaded) {
            coreLogger.addFilter(filter);
        }
    }
}

