/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.world_management;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.kosmos.world_creator.WorldCreatorData;
import us.tlatoani.kosmos.world_management.world_loader.WorldLoader;

public class EffCreateWorldUsingCreator
extends Effect {
    private Expression<String> worldName;
    private Expression<WorldCreatorData> creator;
    private boolean load;
    private boolean autoload;

    protected void execute(Event event) {
        Optional<String> worldName = Optional.ofNullable(this.worldName).map(expr -> (String)expr.getSingle(event));
        WorldCreatorData creator = (WorldCreatorData)this.creator.getSingle(event);
        creator = worldName.map(creator::setName).orElse(creator);
        if (!creator.name.isPresent()) {
            Skript.warning((String)("Attempted to create a world using a creator without a name: " + creator));
            return;
        }
        if (this.load && !WorldCreatorData.worldExists(creator.name.get())) {
            return;
        }
        creator.createWorld();
        if (this.autoload) {
            WorldLoader.setCreator(creator);
        }
    }

    public String toString(Event paramEvent, boolean paramBoolean) {
        return (this.load ? "load" : "create new") + " world" + (this.worldName != null ? " named " + this.worldName : "") + " using " + this.creator;
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.load = (parseResult.mark & 1) == 1;
        this.autoload = (parseResult.mark & 2) == 2;
        this.worldName = expressions[0];
        this.creator = expressions[1];
        return true;
    }
}

