/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.core.registration;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.util.Pair;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.bukkit.command.CommandSender;
import us.tlatoani.kosmos.core.base.MundoAddon;
import us.tlatoani.kosmos.core.registration.DocumentationBuilder;
import us.tlatoani.kosmos.core.registration.ImmutableListCollector;

public abstract class DocumentationElement {
    public final ElementType type;
    public final String name;
    public final String category;
    public final ImmutableList<String> syntaxes;
    public final ImmutableList<String> description;
    public final String originVersion;
    public final ImmutableList<String> requiredPlugins;
    public final ImmutableList<ImmutableList<String>> examples;

    public abstract void display(CommandSender var1);

    protected void displayHeader(CommandSender sender) {
        sender.sendMessage(MundoAddon.formatInfo((this.category.isEmpty() ? "" : this.category + " ") + (Object)((Object)this.type), this.name));
        sender.sendMessage(MundoAddon.formatInfo("Since", MundoAddon.name() + " " + this.originVersion));
        if (this.requiredPlugins.size() > 0) {
            sender.sendMessage(MundoAddon.formatInfo("Required Plugins", String.join((CharSequence)" ", this.requiredPlugins)));
        }
    }

    protected void displaySyntax(CommandSender sender) {
        if (this.syntaxes.size() == 1) {
            sender.sendMessage(MundoAddon.formatInfo("Syntax", (String)this.syntaxes.get(0)));
        } else {
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Syntaxes");
            for (String syntax : this.syntaxes) {
                sender.sendMessage(MundoAddon.getAltChatColor() + syntax);
            }
        }
    }

    protected void displayDesc(CommandSender sender) {
        if (this.description.size() == 1) {
            sender.sendMessage(MundoAddon.formatInfo("Description", (String)this.description.get(0)));
        } else {
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Description");
            for (String descLine : this.description) {
                sender.sendMessage(MundoAddon.getAltChatColor() + descLine);
            }
        }
    }

    protected void displayExamples(CommandSender sender) {
        for (int i = 1; i <= this.examples.size(); ++i) {
            ImmutableList example = (ImmutableList)this.examples.get(i - 1);
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Example " + i);
            for (int line = 1; line <= example.size(); ++line) {
                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "" + String.format(Locale.US, "%02d", line) + " " + MundoAddon.getAltChatColor() + (String)example.get(line - 1));
            }
        }
    }

    public String toString() {
        return "DocumentationElement(" + this.category + " " + (Object)((Object)this.type) + ": " + this.name + ")";
    }

    private DocumentationElement(ElementType type, String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, List<String[]> examples) {
        this.type = type;
        this.name = name;
        this.category = category;
        this.syntaxes = (ImmutableList)Arrays.stream(syntaxes).map(syntax -> syntax.replaceAll("\\d+\u00a6", "")).collect(new ImmutableListCollector());
        this.description = ImmutableList.copyOf((Object[])description);
        this.originVersion = originVersion;
        this.requiredPlugins = ImmutableList.copyOf((Object[])requiredPlugins);
        this.examples = (ImmutableList)examples.stream().map(ImmutableList::copyOf).collect(new ImmutableListCollector());
    }

    public static class Scope
    extends DocumentationElement {
        @Override
        public void display(CommandSender sender) {
            this.displayHeader(sender);
            this.displaySyntax(sender);
            this.displayDesc(sender);
            this.displayExamples(sender);
        }

        public Scope(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, List<String[]> examples) {
            super(ElementType.SCOPE, name, category, syntaxes, description, originVersion, requiredPlugins, examples);
        }
    }

    public static class Type
    extends DocumentationElement {
        public final ImmutableList<String> usages;

        public Type(String name, String category, String[] syntaxes, String[] usages, String[] description, String originVersion, String[] requiredPlugins, List<String[]> examples) {
            super(ElementType.TYPE, name, category, syntaxes, description, originVersion, requiredPlugins, examples);
            this.usages = ImmutableList.copyOf((Object[])usages);
        }

        @Override
        public void display(CommandSender sender) {
            this.displayHeader(sender);
            this.displaySyntax(sender);
            sender.sendMessage(MundoAddon.formatInfo("Usages", this.usages.size() == 0 ? "Cannot be written in scripts" : String.join((CharSequence)", ", this.usages)));
            this.displayDesc(sender);
            this.displayExamples(sender);
        }
    }

    public static class EventValue {
        public final Event parent;
        public final String typeName;
        public final String description;
        public final String originVersion;

        public EventValue(Event parent, String typeName, String description, String originVersion) {
            this.parent = parent;
            this.typeName = typeName;
            this.description = description;
            this.originVersion = originVersion;
        }

        public void display(CommandSender sender) {
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + "event-" + this.typeName + (this.originVersion.equals(this.parent.originVersion) ? "" : MundoAddon.getTriChatColor() + " Since " + this.originVersion) + MundoAddon.getAltChatColor() + " " + this.description);
        }
    }

    public static class Event
    extends DocumentationElement {
        public final boolean cancellable;
        public final ImmutableList<EventValue> eventValues;

        public Event(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, List<String[]> examples, boolean cancellable, Collection<DocumentationBuilder.EventValue> eventValueBuilders) {
            super(ElementType.EVENT, name, category, syntaxes, description, originVersion, requiredPlugins, examples);
            this.cancellable = cancellable;
            this.eventValues = (ImmutableList)eventValueBuilders.stream().map(builder -> builder.build(this)).collect(new ImmutableListCollector());
        }

        @Override
        public void display(CommandSender sender) {
            this.displayHeader(sender);
            sender.sendMessage(MundoAddon.formatInfo("Cancellable", this.cancellable ? "Yes" : "No"));
            this.displaySyntax(sender);
            this.displayDesc(sender);
            if (this.eventValues.size() > 0) {
                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Event Values");
                for (EventValue eventValue : this.eventValues) {
                    eventValue.display(sender);
                }
            }
            this.displayExamples(sender);
        }
    }

    public static class Changer {
        public final DocumentationElement parent;
        public final Changer.ChangeMode mode;
        public final Optional<Pair<ClassInfo, Boolean>> type;
        public final String description;
        public final String originVersion;

        public Changer(DocumentationElement parent, Changer.ChangeMode mode, Optional<Pair<ClassInfo, Boolean>> type, String description, String originVersion) {
            this.parent = parent;
            this.mode = mode;
            this.type = type;
            this.description = description;
            this.originVersion = originVersion;
        }

        public static String modeSyntax(Changer.ChangeMode mode) {
            switch (mode) {
                case ADD: 
                case REMOVE: 
                case RESET: {
                    return mode.name().toLowerCase();
                }
                case SET: {
                    return "set to";
                }
                case DELETE: {
                    return "clear/delete";
                }
                case REMOVE_ALL: {
                    return "remove all";
                }
            }
            throw new IllegalArgumentException("Mode: " + mode);
        }

        public void display(CommandSender sender) {
            String typeSyntax = this.type.map(pair -> " " + ((ClassInfo)pair.getFirst()).getCodeName() + ((Boolean)pair.getSecond() != false ? "" : "s")).orElse("");
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + Changer.modeSyntax(this.mode) + typeSyntax + (this.originVersion.equals(this.parent.originVersion) ? "" : MundoAddon.getTriChatColor() + " Since " + this.originVersion) + MundoAddon.getAltChatColor() + " " + this.description);
        }
    }

    public static class Expression
    extends DocumentationElement {
        public final ClassInfo type;
        public final ImmutableList<Changer> changers;

        public Expression(String name, String category, String[] syntaxes, String[] description, String originVersion, ClassInfo type, String[] requiredPlugins, List<String[]> examples, List<DocumentationBuilder.Changer> changerBuilders) {
            super(ElementType.EXPRESSION, name, category, syntaxes, description, originVersion, requiredPlugins, examples);
            this.type = type;
            this.changers = (ImmutableList)changerBuilders.stream().map(builder -> builder.build(this)).collect(new ImmutableListCollector());
        }

        @Override
        public void display(CommandSender sender) {
            this.displayHeader(sender);
            sender.sendMessage(MundoAddon.formatInfo("Type", this.type.getDocName()));
            this.displaySyntax(sender);
            this.displayDesc(sender);
            if (this.changers.size() > 0) {
                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Changers");
                for (Changer changer : this.changers) {
                    changer.display(sender);
                }
            }
            this.displayExamples(sender);
        }
    }

    public static class Condition
    extends DocumentationElement {
        public final ImmutableList<Changer> changers;

        public Condition(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, List<String[]> examples, Collection<DocumentationBuilder.Changer> changerBuilders) {
            super(ElementType.CONDITION, name, category, syntaxes, description, originVersion, requiredPlugins, examples);
            this.changers = (ImmutableList)changerBuilders.stream().map(builder -> builder.build(this)).collect(new ImmutableListCollector());
        }

        @Override
        public void display(CommandSender sender) {
            this.displayHeader(sender);
            this.displaySyntax(sender);
            this.displayDesc(sender);
            if (this.changers.size() > 0) {
                sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Changers");
                for (Changer changer : this.changers) {
                    changer.display(sender);
                }
            }
            this.displayExamples(sender);
        }
    }

    public static class Effect
    extends DocumentationElement {
        @Override
        public void display(CommandSender sender) {
            this.displayHeader(sender);
            this.displaySyntax(sender);
            this.displayDesc(sender);
            this.displayExamples(sender);
        }

        public Effect(String name, String category, String[] syntaxes, String[] description, String originVersion, String[] requiredPlugins, List<String[]> examples) {
            super(ElementType.EFFECT, name, category, syntaxes, description, originVersion, requiredPlugins, examples);
        }
    }

    public static enum ElementType {
        EFFECT("Effect"),
        CONDITION("Condition"),
        EXPRESSION("Expression"),
        EVENT("Event"),
        TYPE("Type"),
        SCOPE("Scope");

        public final String toString;

        private ElementType(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

