/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.core.base;

import ch.njol.skript.Skript;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import us.tlatoani.kosmos.core.base.MundoAddon;

public final class Logging {
    public static Logger getLogger() {
        return MundoAddon.get().getLogger();
    }

    public static boolean classDebugs(Class c) {
        return MundoAddon.DEBUG_PACKAGES.getCurrentValue().contains(Logging.getMundoCategory(c));
    }

    public static String getMundoCategory(Class<?> c) {
        return c.getName().split("\\.")[3];
    }

    public static void info(String s) {
        Logging.getLogger().info(s);
    }

    public static void reportException(Object obj, Exception e) {
        Logging.info("An exception has occured within " + MundoAddon.name());
        Logging.info("Please create an issue regarding this on " + MundoAddon.name() + "'s GitHub page: " + MundoAddon.getGitHubLink());
        Logging.info("You can also run the '/" + MundoAddon.get().commandName + " desc' command and go to one of the links provided for help.");
        Logging.info("Bukkit/Spigot version: " + Bukkit.getVersion());
        Logging.info("Skript version: " + Skript.getVersion());
        Logging.info(MundoAddon.name() + " version: " + MundoAddon.version());
        Logging.info("Exception at " + (obj instanceof Class ? (Class<?>)obj : obj.getClass()).getSimpleName());
        e.printStackTrace();
    }

    public static void debug(Object obj, String msg) {
        Class<?> debugClass;
        Class<?> clazz = debugClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (Logging.classDebugs(debugClass)) {
            Logging.info("DEBUG " + debugClass.getSimpleName() + ": " + msg);
        }
    }

    public static void debug(Object obj, Exception e) {
        Class<?> debugClass;
        Class<?> clazz = debugClass = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        if (Logging.classDebugs(debugClass)) {
            Logging.info("DEBUG");
            Logging.info("An exception was reported for debugging while debug_mode was activated in the config");
            Logging.info("If you were told to activate debug_mode to help fix bugs in " + MundoAddon.name() + " on forums.skunity.com, then please copy and paste this message along with the full stack trace of the following error to hastebin.com and give the hastebin link to whoever is helping you fix this bug");
            Logging.info("If you are trying to fix a problem in " + MundoAddon.name() + " yourself, good luck :)");
            Logging.info("Otherwise, if you do not know why you are seeing this error here, go to the " + MundoAddon.name() + " config, set debug_mode to false, and restart your server");
            Logging.info("For help, run the '/" + MundoAddon.get().commandName + " desc' command and go to one of the links provided.");
            Logging.info("Bukkit/Spigot version: " + Bukkit.getVersion());
            Logging.info("Skript version: " + Skript.getVersion());
            Logging.info(MundoAddon.name() + " version: " + MundoAddon.version());
            Logging.info("Exception debugged at " + debugClass.getSimpleName());
            e.printStackTrace();
        }
    }
}

