/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.world_management.world_loader;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import us.tlatoani.kosmos.Kosmos;
import us.tlatoani.kosmos.core.base.Logging;
import us.tlatoani.kosmos.world_creator.WorldCreatorData;

public final class WorldLoader {
    private static Map<String, WorldCreatorData> worldLoaderSaver = new HashMap<String, WorldCreatorData>();
    private static final String FILENAME = "worldloader.json";

    public static void load() {
        try {
            WorldLoader.readJSONObject(WorldLoader.getLoaderFile()).forEach((key, value) -> {
                String s = (String)key;
                JSONObject jsonObject = (JSONObject)value;
                WorldCreatorData creator = WorldCreatorData.fromJSON(s, jsonObject).get();
                WorldLoader.setCreator(creator);
                creator.createWorld();
            });
            if (worldLoaderSaver.isEmpty()) {
                Logging.info("No worlds were assigned to load automatically");
            } else {
                Logging.info("Worlds to automatically load were loaded successfully!");
            }
        }
        catch (IOException | ClassCastException | NoSuchElementException | ParseException e) {
            Logging.info("Kosmos encountered problems while reading the file for automatically loaded worlds");
            Logging.info("Any worlds set to automatically load were not loaded");
            Logging.reportException(WorldLoader.class, (Exception)e);
        }
    }

    public static void save() throws IOException {
        FileWriter writer = new FileWriter(WorldLoader.getLoaderFile());
        writer.write(WorldLoader.getJSONOfData().toString());
        writer.flush();
        writer.close();
    }

    public static File getLoaderFile() throws IOException {
        File result = new File(Kosmos.get().getDataFolder().getAbsolutePath() + File.separator + FILENAME);
        if (!result.exists()) {
            result.createNewFile();
            JSONObject emptyObject = new JSONObject();
            FileWriter writer = new FileWriter(result);
            writer.write(emptyObject.toString());
            writer.flush();
            writer.close();
        }
        return result;
    }

    public static JSONObject readJSONObject(File jsonFile) throws IOException, ParseException, ClassCastException {
        return (JSONObject)new JSONParser().parse((Reader)new FileReader(jsonFile));
    }

    public static JSONObject getJSONOfData() {
        JSONObject jsonObject = new JSONObject();
        worldLoaderSaver.forEach((s, creator) -> jsonObject.put(s, (Object)creator.toJSON()));
        return jsonObject;
    }

    public static WorldCreatorData getCreator(String worldname) {
        return worldLoaderSaver.get(worldname);
    }

    public static void setCreator(WorldCreatorData creator) {
        if (!creator.name.isPresent()) {
            throw new IllegalArgumentException("You cannot set a nameless creator as automatic!");
        }
        worldLoaderSaver.put(creator.name.get(), creator);
    }

    public static void removeCreator(String worldname) {
        worldLoaderSaver.remove(worldname);
    }

    public static WorldCreatorData[] getAllCreators() {
        return worldLoaderSaver.values().toArray(new WorldCreatorData[0]);
    }

    public static Iterator<WorldCreatorData> getCreatorIterator() {
        return worldLoaderSaver.values().iterator();
    }

    public static void clearAllCreators() {
        worldLoaderSaver.clear();
    }
}

