/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.miscellaneous;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.Event;

public class ExprGameRule
extends SimpleExpression<Object> {
    private GameRule gameRule;
    private boolean def;
    private Expression<World> worldExpression;

    protected Object[] get(Event event) {
        World world = (World)this.worldExpression.getSingle(event);
        if (world == null) {
            return new Object[0];
        }
        return new Object[]{this.def ? world.getGameRuleDefault(this.gameRule) : world.getGameRuleValue(this.gameRule)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<?> getReturnType() {
        if (this.gameRule.getType() == Integer.class) {
            return Number.class;
        }
        return this.gameRule.getType();
    }

    public static String getSkriptGameRuleName(GameRule<?> gameRule) {
        StringBuilder builder = new StringBuilder();
        for (char chara : gameRule.getName().toCharArray()) {
            if (Character.isUpperCase(chara)) {
                builder.append(" ");
            }
            builder.append(Character.toLowerCase(chara));
        }
        return builder.toString();
    }

    public String toString(Event e, boolean debug) {
        if (this.gameRule.getType() == Boolean.class) {
            return ExprGameRule.getSkriptGameRuleName(this.gameRule) + " rule " + (this.def ? "default " : "") + "in " + this.worldExpression;
        }
        return (this.def ? "default " : "") + ExprGameRule.getSkriptGameRuleName(this.gameRule) + " in " + this.worldExpression;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.gameRule = GameRule.values()[matchedPattern];
        this.def = parseResult.mark == 1;
        this.worldExpression = exprs[0];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode mode) {
        World world = (World)this.worldExpression.getSingle(event);
        Object value = null;
        if (mode == Changer.ChangeMode.SET && (value = delta[0]) != null && this.gameRule.getType() == Integer.class) {
            value = ((Number)value).intValue();
        }
        if (value == null) {
            value = world.getGameRuleDefault(this.gameRule);
        }
        world.setGameRule(this.gameRule, value);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.def) {
            return null;
        }
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{this.getReturnType()});
        }
        return null;
    }
}

