/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.core.updating;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;

public class HTTPClient {
    private final URL url;
    private final HttpURLConnection connection;

    public HTTPClient(URL url) throws IOException {
        this.url = url;
        this.connection = (HttpURLConnection)url.openConnection();
    }

    public static HTTPClient url(String str, Object ... format) throws IOException {
        return new HTTPClient(new URL(String.format(str, format)));
    }

    public HTTPClient method(String method) throws ProtocolException {
        this.connection.setRequestMethod(method);
        return this;
    }

    public HTTPClient timeout(int timeoutMillis) {
        this.connection.setConnectTimeout(timeoutMillis);
        this.connection.setReadTimeout(timeoutMillis);
        return this;
    }

    public OutputStream getOutput() throws IOException {
        this.connection.setDoOutput(true);
        return this.connection.getOutputStream();
    }

    public HTTPClient uploadFile(String path) throws IOException {
        File file = new File(path);
        String boundary = Long.toHexString(System.currentTimeMillis());
        String separator = "\r\n";
        this.connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        OutputStream output = this.getOutput();
        PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, "UTF-8"), true);
        writer.append("--").append(boundary).append(separator);
        writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"").append(file.getName()).append("\"").append(separator);
        writer.append("Content-Type: application/octet-stream").append(separator);
        writer.append(separator).flush();
        Files.copy(file.toPath(), output);
        output.flush();
        writer.append(separator).flush();
        writer.append("--").append(boundary).append("--").append(separator).flush();
        return this;
    }

    public int statusCode() throws IOException {
        return this.connection.getResponseCode();
    }

    public String statusMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    public Map<String, List<String>> getHeaders() {
        return this.connection.getHeaderFields();
    }

    public InputStream getInput() throws IOException {
        return this.connection.getInputStream();
    }
}

