/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.chunk;

import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import org.bukkit.Chunk;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

public class ExprChunkBlock
extends SimpleExpression<Block> {
    private Expression<Chunk> chunkExpression;
    private Expression<Number> xExpr = null;
    private Expression<Number> yExpr;
    private Expression<Number> zExpr;
    private int level;
    public static final int LAYER = 0;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int SEA_LEVEL = 3;
    private boolean south;
    private boolean east;
    private boolean center;
    public static int NS = 4;
    public static int EW = 8;
    public static int CORCEN = 16;

    public static int getLevel(int level, Expression<Number> expression, Event event) {
        switch (level) {
            case 0: {
                return ((Number)expression.getSingle(event)).intValue();
            }
            case 1: {
                return 255;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 63;
            }
        }
        throw new IllegalArgumentException("level = " + level + " is not 0, 1, 2, 3");
    }

    public static String levelString(int level, Expression<Number> expression) {
        switch (level) {
            case 0: {
                return "layer " + expression;
            }
            case 1: {
                return "top";
            }
            case 2: {
                return "bottom";
            }
            case 3: {
                return "sea level";
            }
        }
        throw new IllegalArgumentException("level = " + level + " is not 0, 1, 2, 3");
    }

    protected Block[] get(Event event) {
        int z;
        int y;
        int x;
        Chunk chunk = (Chunk)this.chunkExpression.getSingle(event);
        if (chunk == null) {
            return new Block[0];
        }
        if (this.xExpr != null) {
            x = ((Number)this.xExpr.getSingle(event)).intValue();
            y = ((Number)this.yExpr.getSingle(event)).intValue();
            z = ((Number)this.zExpr.getSingle(event)).intValue();
        } else {
            y = ExprChunkBlock.getLevel(this.level, this.yExpr, event);
            if (this.center) {
                x = this.east ? 8 : 7;
                z = this.south ? 8 : 7;
            } else {
                x = this.east ? 15 : 0;
                z = this.south ? 15 : 0;
            }
        }
        return new Block[]{chunk.getBlock(x, y, z)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Block> getReturnType() {
        return Block.class;
    }

    public String toString(Event event, boolean b) {
        if (this.xExpr != null) {
            return "block at " + this.xExpr + ", " + this.yExpr + ", " + this.zExpr + " in " + this.chunkExpression;
        }
        return ExprChunkBlock.levelString(this.level, this.yExpr) + " " + (this.south ? "south" : "north") + (this.east ? "east " : "west") + " " + (this.center ? "center" : "corner") + " of " + this.chunkExpression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        if (i == 0) {
            this.xExpr = expressions[0];
            this.yExpr = expressions[1];
            this.zExpr = expressions[2];
            this.chunkExpression = expressions[3];
        } else {
            int mark = parseResult.mark;
            this.yExpr = expressions[0];
            this.level = mark % 4;
            this.south = (mark & NS) == 0;
            this.east = (mark & EW) == 0;
            this.center = (mark & CORCEN) == 0;
            this.chunkExpression = expressions[1];
        }
        return true;
    }
}

