/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.border.event;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.function.Function;
import org.bukkit.World;
import org.bukkit.event.Event;
import us.tlatoani.kosmos.border.event.WorldBorderImpl;

public class ExprBorderMovingValue
extends SimpleExpression<Number> {
    private Expression<World> worldExpression;
    private Type type;

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public boolean isSingle() {
        return true;
    }

    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean arg2, SkriptParser.ParseResult parseResult) {
        this.worldExpression = expr[0];
        if ((parseResult.mark & 8) == 8) {
            Skript.warning((String)"Use of the 'size' alias for border diameter is discouraged. Please use 'diameter' instead.");
        }
        this.type = Type.values()[parseResult.mark & 7];
        return true;
    }

    public String toString(Event event, boolean arg1) {
        return this.type.syntax + " of " + this.worldExpression;
    }

    protected Number[] get(Event event) {
        World world = (World)this.worldExpression.getSingle(event);
        if (world.getWorldBorder() instanceof WorldBorderImpl) {
            WorldBorderImpl border = (WorldBorderImpl)world.getWorldBorder();
            return new Number[]{this.type.getValue(border)};
        }
        return new Number[0];
    }

    public static enum Type {
        ORIGINAL_DIAMETER("original diameter", WorldBorderImpl::getOriginalDiameter),
        EVENTUAL_DIAMETER("eventual diameter", WorldBorderImpl::getEventualDiameter),
        REMAINING_DISTANCE("remaining distance", WorldBorderImpl::getRemainingDistance);

        public final String syntax;
        public final Function<WorldBorderImpl, Double> function;

        private Type(String syntax, Function<WorldBorderImpl, Double> function) {
            this.syntax = syntax;
            this.function = function;
        }

        public Double getValue(WorldBorderImpl border) {
            return this.function.apply(border);
        }
    }
}

