/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.generator;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.util.Kleenean;
import java.util.Optional;
import org.bukkit.event.Event;
import us.tlatoani.kosmos.core.event_scope.ScopeUtil;

public class Subsection<E extends Event> {
    public final String syntax;
    public final String eventName;
    public final Class<E> eventClass;
    private Optional<TriggerItem> triggerItem = Optional.empty();
    private Optional<SectionNode> sectionNode = Optional.empty();

    public Subsection(String syntax, String eventName, Class<E> eventClass) {
        this.syntax = syntax;
        this.eventName = eventName;
        this.eventClass = eventClass;
    }

    public Kleenean trySectionNode(SectionNode sectionNode) {
        if (sectionNode.getKey().equals(this.syntax) || sectionNode.getKey().equals("sync " + this.syntax)) {
            if (this.sectionNode.isPresent()) {
                Skript.error((String)("You cannot have two '" + this.syntax + "' sections here!"));
                return Kleenean.FALSE;
            }
            this.sectionNode = Optional.of(sectionNode);
            return Kleenean.TRUE;
        }
        return Kleenean.UNKNOWN;
    }

    public void load() {
        this.triggerItem = this.sectionNode.flatMap(sectionNode -> {
            ScriptLoader.setCurrentEvent((String)this.eventName, (Class[])new Class[]{this.eventClass});
            return ScopeUtil.loadSectionNode(sectionNode, null);
        });
        this.sectionNode = Optional.empty();
    }

    public void unload() {
        this.triggerItem = Optional.empty();
        this.sectionNode = Optional.empty();
    }

    public void run(E event) {
        this.triggerItem.ifPresent(t -> TriggerItem.walk((TriggerItem)t, (Event)event));
    }

    public String toString() {
        return "Subsection(syntax: " + this.syntax + "triggerItem: " + this.triggerItem + ")";
    }
}

