/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.core.registration;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Comparator;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Comparators;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.registrations.EventValues;
import ch.njol.skript.util.Getter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.event.Event;
import us.tlatoani.kosmos.core.base.Logging;
import us.tlatoani.kosmos.core.registration.DocumentationBuilder;
import us.tlatoani.kosmos.core.registration.MundoClassInfo;

public final class Registration {
    private static String currentCategory = "";
    private static boolean categoriesEnabled = false;
    private static String[] currentRequiredPlugins = new String[0];

    public static boolean areCategoriesEnabled() {
        return categoriesEnabled;
    }

    public static void register(String category, Runnable registerer, String ... requiredPlugins) {
        categoriesEnabled = true;
        String prevCategory = currentCategory;
        String[] prevPlugins = currentRequiredPlugins;
        currentCategory = category;
        currentRequiredPlugins = requiredPlugins;
        registerer.run();
        currentCategory = prevCategory;
        currentRequiredPlugins = prevPlugins;
    }

    public static String getCurrentCategory() {
        return currentCategory;
    }

    public static String[] getCurrentRequiredPlugins() {
        return currentRequiredPlugins;
    }

    public static DocumentationBuilder.Effect registerEffect(Class<? extends Effect> effectClass, String ... patterns) {
        Skript.registerEffect(effectClass, (String[])patterns);
        return (DocumentationBuilder.Effect)new DocumentationBuilder.Effect(currentCategory, patterns).requiredPlugins(currentRequiredPlugins);
    }

    public static <T> DocumentationBuilder.Expression registerExpression(Class<? extends Expression<T>> expressionClass, Class<T> type, ExpressionType expressionType, String ... patterns) {
        Skript.registerExpression(expressionClass, type, (ExpressionType)expressionType, (String[])patterns);
        return (DocumentationBuilder.Expression)new DocumentationBuilder.Expression(currentCategory, patterns, type, expressionClass).requiredPlugins(currentRequiredPlugins);
    }

    public static DocumentationBuilder.Condition registerExpressionCondition(Class<? extends Expression<Boolean>> expressionClass, ExpressionType expressionType, String ... patterns) {
        Skript.registerExpression(expressionClass, Boolean.class, (ExpressionType)expressionType, (String[])patterns);
        return (DocumentationBuilder.Condition)new DocumentationBuilder.Condition(currentCategory, patterns, expressionClass).requiredPlugins(currentRequiredPlugins);
    }

    public static void registerCondition(Class<? extends Condition> conditionClass, String ... patterns) {
        Skript.registerCondition(conditionClass, (String[])patterns);
    }

    public static DocumentationBuilder.Event registerEvent(String name, Class<? extends SkriptEvent> eventClass, Class<? extends Event> eventType, String ... patterns) {
        Skript.registerEvent((String)name, eventClass, eventType, (String[])patterns);
        return (DocumentationBuilder.Event)new DocumentationBuilder.Event(currentCategory, patterns, eventType).requiredPlugins(currentRequiredPlugins);
    }

    public static <E extends Event, R> void registerEventValue(final Class<E> tClass, final Class<R> rClass, final Function<E, R> function) {
        EventValues.registerEventValue(tClass, rClass, (Getter)new Getter<R, E>(){

            public R get(E event) {
                try {
                    return function.apply(event);
                }
                catch (ClassCastException e) {
                    Logging.debug(Registration.class, "tClass = " + tClass + ", rClass = " + rClass + ", function = " + function);
                    Logging.debug(Registration.class, e);
                    return null;
                }
            }
        }, (int)0);
    }

    public static <A, B> void registerComparator(Class<A> aClass, Class<B> bClass, final boolean supportsOrdering, final BiFunction<A, B, Comparator.Relation> comparator) {
        Comparators.registerComparator(aClass, bClass, (Comparator)new Comparator<A, B>(){

            public Comparator.Relation compare(A a, B b) {
                return (Comparator.Relation)comparator.apply(a, b);
            }

            public boolean supportsOrdering() {
                return supportsOrdering;
            }
        });
    }

    public static <F, T> void registerConverter(Class<F> from, Class<T> to, Function<F, T> function) {
        Converters.registerConverter(from, to, function::apply);
    }

    public static Boolean classInfoSafe(Class c, String name) {
        return Classes.getExactClassInfo((Class)c) == null && Classes.getClassInfoNoError((String)name) == null;
    }

    public static <T> MundoClassInfo<T> registerType(Class<T> type, String name, String ... alternateNames) {
        ArrayList<String> names = new ArrayList<String>(Arrays.asList(alternateNames));
        names.add(0, name);
        MundoClassInfo<T> result = new MundoClassInfo<T>(type, names.toArray(new String[0]), currentCategory);
        result.parser(new SimpleParser<T>(){

            public T parse(String s, ParseContext parseContext) {
                return null;
            }
        });
        if (Registration.classInfoSafe(type, name).booleanValue()) {
            Classes.registerClass(result);
        }
        return result.requiredPlugins(currentRequiredPlugins);
    }

    public static abstract class SimpleParser<T>
    extends Parser<T> {
        public String toString(T t, int flags) {
            Logging.debug(Registration.class, "toString() for " + t + "; flags: " + flags);
            return t.toString();
        }

        public String toVariableNameString(T t) {
            return this.toString(t, 0);
        }

        public String getVariableNamePattern() {
            return ".+";
        }
    }
}

