/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.core.base;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import us.tlatoani.kosmos.core.base.MundoAddon;

public final class Config {
    private static final List<Option> options = new ArrayList<Option>();

    public static void reload() {
        MundoAddon.get().saveDefaultConfig();
        MundoAddon.get().reloadConfig();
        FileConfiguration config = MundoAddon.get().getConfig();
        options.forEach(option -> ((Option)option).loadValue(config));
    }

    public static void accessConfig(CommandSender sender, String[] args) {
        if (args.length >= 2 && args[1].equalsIgnoreCase("reload")) {
            Config.reload();
            sender.sendMessage(MundoAddon.getPrimaryChatColor() + "Reloaded " + MundoAddon.name() + "'s Config!");
        }
        sender.sendMessage(MundoAddon.getPrimaryChatColor() + MundoAddon.name() + " Config");
        for (Option option : options) {
            sender.sendMessage(MundoAddon.formatInfo(option.path, option.getCurrentValue().toString()));
        }
    }

    public static class Option<T> {
        public final String path;
        private final T defaultValue;
        private final BiFunction<FileConfiguration, String, T> function;
        private T currentValue = null;

        public Option(String path, T defaultValue, BiFunction<FileConfiguration, String, T> function) {
            this.path = path;
            this.defaultValue = defaultValue;
            this.function = function;
            options.add(this);
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        private void addDefault(FileConfiguration config) {
            config.addDefault(this.path, this.defaultValue);
        }

        private void loadValue(FileConfiguration config) {
            this.currentValue = this.function.apply(config, this.path);
        }
    }
}

