/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos.border;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import ch.njol.util.coll.CollectionUtils;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.event.Event;

public class ExprPropertyOfBorder
extends SimpleExpression<Number> {
    private BorderProperty borderProperty;
    private Expression<World> worldExpression;

    protected Number[] get(Event event) {
        WorldBorder border = ((World)this.worldExpression.getSingle(event)).getWorldBorder();
        return new Number[]{this.borderProperty.get(border)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    public String toString(Event event, boolean b) {
        return this.borderProperty.syntaxName + " of " + this.worldExpression;
    }

    public boolean init(Expression<?>[] expressions, int i, Kleenean kleenean, SkriptParser.ParseResult parseResult) {
        this.worldExpression = expressions[0];
        if ((parseResult.mark & 8) == 8) {
            Skript.warning((String)"The 'size' alias for border diameter is not recommended as it is vague and may cause conflicts. Please use 'diameter' instead. If you were not trying to use a border syntax here, please report this as a bug to the creator of Kosmos. ");
        }
        this.borderProperty = BorderProperty.values()[parseResult.mark & 7];
        return true;
    }

    public void change(Event event, Object[] delta, Changer.ChangeMode changeMode) {
        WorldBorder border = ((World)this.worldExpression.getSingle(event)).getWorldBorder();
        if (changeMode == Changer.ChangeMode.SET || changeMode == Changer.ChangeMode.ADD || changeMode == Changer.ChangeMode.REMOVE) {
            Number value = (Number)delta[0];
            if (changeMode == Changer.ChangeMode.ADD) {
                value = this.borderProperty.get(border).doubleValue() + value.doubleValue();
            } else if (changeMode == Changer.ChangeMode.REMOVE) {
                value = this.borderProperty.get(border).doubleValue() + value.doubleValue();
            }
            this.borderProperty.set(border, value);
        } else if (changeMode == Changer.ChangeMode.RESET) {
            this.borderProperty.set(border, this.borderProperty.defaultValue);
        } else {
            throw new IllegalArgumentException("Illegal ChangeMode: " + changeMode);
        }
    }

    public Class[] acceptChange(Changer.ChangeMode changeMode) {
        switch (changeMode) {
            case SET: 
            case ADD: 
            case REMOVE: 
            case RESET: {
                return (Class[])CollectionUtils.array((Object[])new Class[]{Number.class});
            }
        }
        return null;
    }

    public static enum BorderProperty {
        DIAMETER("diameter", 6.0E7, WorldBorder::getSize, Number::doubleValue, WorldBorder::setSize),
        DAMAGE_AMOUNT("damage amount", 0.2, WorldBorder::getDamageAmount, Number::doubleValue, WorldBorder::setDamageAmount),
        DAMAGE_BUFFER("damage buffer", 5.0, WorldBorder::getDamageBuffer, Number::doubleValue, WorldBorder::setDamageBuffer),
        WARNING_DISTANCE("warning distance", 5.0, WorldBorder::getWarningDistance, Number::intValue, WorldBorder::setWarningDistance),
        WARNING_TIME("warning time", 15.0, WorldBorder::getWarningTime, Number::intValue, WorldBorder::setWarningTime);

        public final String syntaxName;
        public final Double defaultValue;
        private final Function<WorldBorder, Number> getter;
        private final BiConsumer<WorldBorder, Number> setter;

        private <T> BorderProperty(String syntaxName, double defaultValue, Function<WorldBorder, Number> getter, Function<Number, T> numConverter, BiConsumer<WorldBorder, T> setter) {
            this.syntaxName = syntaxName;
            this.defaultValue = defaultValue;
            this.getter = getter;
            this.setter = (border, number) -> setter.accept((WorldBorder)border, (Object)numConverter.apply((Number)number));
        }

        public Number get(WorldBorder border) {
            return this.getter.apply(border);
        }

        public void set(WorldBorder border, Number value) {
            this.setter.accept(border, value);
        }
    }
}

