/*
 * Decompiled with CFR 0.152.
 */
package us.tlatoani.kosmos;

import ch.njol.skript.Skript;
import java.io.IOException;
import org.bukkit.ChatColor;
import us.tlatoani.kosmos.border.BorderMundo;
import us.tlatoani.kosmos.chunk.ChunkMundo;
import us.tlatoani.kosmos.core.base.Logging;
import us.tlatoani.kosmos.core.base.MundoAddon;
import us.tlatoani.kosmos.core.bstats.bukkit.Metrics;
import us.tlatoani.kosmos.core.registration.Documentation;
import us.tlatoani.kosmos.core.registration.Registration;
import us.tlatoani.kosmos.generator.GeneratorManager;
import us.tlatoani.kosmos.miscellaneous.MiscMundo;
import us.tlatoani.kosmos.world_creator.WorldCreatorMundo;
import us.tlatoani.kosmos.world_management.WorldManagementMundo;
import us.tlatoani.kosmos.world_management.world_loader.WorldLoader;

public class Kosmos
extends MundoAddon {
    public Kosmos() {
        super("kosmos", ChatColor.DARK_GREEN, ChatColor.GREEN, ChatColor.AQUA);
        this.link("Metrics", "https://bstats.org/plugin/bukkit/Kosmos");
    }

    @Override
    public void onEnable() {
        super.onEnable();
        Documentation.load();
        WorldLoader.load();
        Registration.register("Border", BorderMundo::load, new String[0]);
        Registration.register("Chunk", ChunkMundo::load, new String[0]);
        Registration.register("Generator", GeneratorManager::load, new String[0]);
        Registration.register("Miscellaneous", MiscMundo::load, new String[0]);
        Registration.register("WorldCreator", WorldCreatorMundo::load, new String[0]);
        Registration.register("WorldManagement", WorldManagementMundo::load, new String[0]);
    }

    @Override
    public void afterPluginsEnabled() {
        Metrics metrics = new Metrics(this);
        metrics.addCustomChart(new Metrics.SimplePie("skript_version", () -> Skript.getVersion().toString()));
    }

    public void onDisable() {
        try {
            WorldLoader.save();
            Logging.info("Successfully saved all (if any) world loaders");
        }
        catch (IOException e) {
            Logging.info("A problem occurred while saving world loaders");
            Logging.reportException((Object)this, e);
        }
    }
}

