/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Version;
import ch.njol.util.coll.CollectionUtils;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Maximum Air")
@Description(value={"Returns the maximum amount of air the living entity can have, in ticks."})
@Examples(value={"set {_max} to the maximum air of target entity"})
@Since(value="1.0.0")
public class ExprMaximumAir
extends SimplePropertyExpression<LivingEntity, Timespan> {
    public Class<? extends Timespan> getReturnType() {
        return Timespan.class;
    }

    protected String getPropertyName() {
        return "maximum air";
    }

    @Nullable
    public Timespan convert(LivingEntity entity) {
        return Timespan.fromTicks_i((long)entity.getMaximumAir());
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{Timespan.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            return;
        }
        int ticks = (int)((Timespan)delta[0]).getTicks_i();
        switch (mode) {
            case ADD: {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    int existing = entity.getMaximumAir();
                    entity.setMaximumAir(existing + ticks);
                }
                break;
            }
            case REMOVE: {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    int existing = entity.getMaximumAir();
                    entity.setMaximumAir(existing - ticks);
                }
                break;
            }
            case SET: {
                for (LivingEntity entity : (LivingEntity[])this.getExpr().getArray(event)) {
                    entity.setMaximumAir(ticks);
                }
                break;
            }
        }
    }

    static {
        if (!Skript.getMinecraftVersion().isSmallerThan(new Version(new int[]{1, 10}))) {
            ExprMaximumAir.register(ExprMaximumAir.class, Timespan.class, (String)"max[imum] air", (String)"livingentities");
        }
    }
}

