/*
 * Decompiled with CFR 0.152.
 */
package me.limeglass.khoryl.elements.entity.zombie.villager;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.coll.CollectionUtils;
import me.limeglass.khoryl.lang.EntityPropertyExpression;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.Event;
import org.eclipse.jdt.annotation.Nullable;

@Name(value="Zombie Villager Conversion Player")
@Description(value={"Gets the player who initiated the conversion."})
@Since(value="1.0.0")
public class ExprConversionPlayer
extends EntityPropertyExpression<LivingEntity, ZombieVillager, OfflinePlayer> {
    protected String getPropertyName() {
        return "conversion player";
    }

    @Override
    @Nullable
    protected OfflinePlayer grab(ZombieVillager villager) {
        if (!villager.isConverting()) {
            return null;
        }
        return villager.getConversionPlayer();
    }

    @Nullable
    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE) {
            return (Class[])CollectionUtils.array((Object[])new Class[]{OfflinePlayer.class});
        }
        return null;
    }

    public void change(Event event, @Nullable Object[] delta, Changer.ChangeMode mode) {
        if (delta[0] == null) {
            Skript.error((String)"Conversion player can't be null.If you're trying to reset the conversion player use the reset/delete changer.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return;
        }
        OfflinePlayer player = (OfflinePlayer)delta[0];
        for (ZombieVillager villager : this.getEntities(event)) {
            villager.setConversionPlayer((OfflinePlayer)(mode == Changer.ChangeMode.SET ? player : null));
        }
    }

    static {
        ExprConversionPlayer.register(ExprConversionPlayer.class, OfflinePlayer.class, (String)"(conversion|converting) player", (String)"livingentities");
    }
}

